/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.LogGeographicalContext;
import com.okta.sdk.resource.model.LogUserAgent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="When an event is triggered by an HTTP request, the `client` object describes the [client](https://datatracker.ietf.org/doc/html/rfc2616) that issues the HTTP request. For instance, the web browser is the client when a user accesses Okta. When this request is received and processed, a sign-in event is fired. When the event isn't sourced to an HTTP request, such as an automatic update, the `client` object field is blank.")
@JsonPropertyOrder(value={"device", "geographicalContext", "id", "ipAddress", "userAgent", "zone"})
public class LogClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DEVICE = "device";
    private String device;
    public static final String JSON_PROPERTY_GEOGRAPHICAL_CONTEXT = "geographicalContext";
    private LogGeographicalContext geographicalContext;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;
    public static final String JSON_PROPERTY_USER_AGENT = "userAgent";
    private LogUserAgent userAgent;
    public static final String JSON_PROPERTY_ZONE = "zone";
    private String zone;

    @Nullable
    @ApiModelProperty(value="Type of device that the client operates from (for example, computer)")
    @JsonProperty(value="device")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDevice() {
        return this.device;
    }

    public LogClient geographicalContext(LogGeographicalContext geographicalContext) {
        this.geographicalContext = geographicalContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="geographicalContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogGeographicalContext getGeographicalContext() {
        return this.geographicalContext;
    }

    @JsonProperty(value="geographicalContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGeographicalContext(LogGeographicalContext geographicalContext) {
        this.geographicalContext = geographicalContext;
    }

    @Nullable
    @ApiModelProperty(value="For OAuth requests, this is the ID of the OAuth [client](https://datatracker.ietf.org/doc/html/rfc6749#section-1.1) making the request. For SSWS token requests, this is the ID of the agent making the request.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="IP address that the client is making its request from")
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    public LogClient userAgent(LogUserAgent userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="userAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogUserAgent getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty(value="userAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserAgent(LogUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    @Nullable
    @ApiModelProperty(value="The `name` of the [Zone](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/NetworkZone/#tag/NetworkZone/operation/getNetworkZone) that the client's location is mapped to")
    @JsonProperty(value="zone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getZone() {
        return this.zone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogClient logClient = (LogClient)o;
        return Objects.equals(this.device, logClient.device) && Objects.equals(this.geographicalContext, logClient.geographicalContext) && Objects.equals(this.id, logClient.id) && Objects.equals(this.ipAddress, logClient.ipAddress) && Objects.equals(this.userAgent, logClient.userAgent) && Objects.equals(this.zone, logClient.zone);
    }

    public int hashCode() {
        return Objects.hash(this.device, this.geographicalContext, this.id, this.ipAddress, this.userAgent, this.zone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogClient {\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    geographicalContext: ").append(this.toIndentedString(this.geographicalContext)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("    zone: ").append(this.toIndentedString(this.zone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

