/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"appInstanceId", "created", "id", "lastUpdated", "lastUpdatedBy", "orgId", "trustedAppInstanceId"})
public class InterclientTrustMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP_INSTANCE_ID = "appInstanceId";
    private String appInstanceId;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;
    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
    private String lastUpdatedBy;
    public static final String JSON_PROPERTY_ORG_ID = "orgId";
    private String orgId;
    public static final String JSON_PROPERTY_TRUSTED_APP_INSTANCE_ID = "trustedAppInstanceId";
    private String trustedAppInstanceId;

    @Nullable
    @ApiModelProperty(example="0oa8ghelqWXs70qD80g5", value="The app ID of the target app")
    @JsonProperty(value="appInstanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppInstanceId() {
        return this.appInstanceId;
    }

    @Nullable
    @ApiModelProperty(example="2025-11-25T22:44:06.000Z", value="Timestamp when the interclient trust mapping was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(example="itmahqusSr3v8Kk3B0g5", value="The unique ID of the interclient trust mapping")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2025-11-25T22:44:06.000Z", value="Timestamp when the interclient trust mapping was updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    @Nullable
    @ApiModelProperty(example="00u102rhXmxEGFKiB0g5", value="ID of the user who created the interclient trust mapping")
    @JsonProperty(value="lastUpdatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    @Nullable
    @ApiModelProperty(example="00o102n9p4vX126Gp0g5", value="ID of the org")
    @JsonProperty(value="orgId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgId() {
        return this.orgId;
    }

    @Nullable
    @ApiModelProperty(example="0oa5kw6q51dFckBE70g5", value="The app ID of the allowed app")
    @JsonProperty(value="trustedAppInstanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTrustedAppInstanceId() {
        return this.trustedAppInstanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterclientTrustMapping interclientTrustMapping = (InterclientTrustMapping)o;
        return Objects.equals(this.appInstanceId, interclientTrustMapping.appInstanceId) && Objects.equals(this.created, interclientTrustMapping.created) && Objects.equals(this.id, interclientTrustMapping.id) && Objects.equals(this.lastUpdated, interclientTrustMapping.lastUpdated) && Objects.equals(this.lastUpdatedBy, interclientTrustMapping.lastUpdatedBy) && Objects.equals(this.orgId, interclientTrustMapping.orgId) && Objects.equals(this.trustedAppInstanceId, interclientTrustMapping.trustedAppInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.appInstanceId, this.created, this.id, this.lastUpdated, this.lastUpdatedBy, this.orgId, this.trustedAppInstanceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InterclientTrustMapping {\n");
        sb.append("    appInstanceId: ").append(this.toIndentedString(this.appInstanceId)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    lastUpdatedBy: ").append(this.toIndentedString(this.lastUpdatedBy)).append("\n");
        sb.append("    orgId: ").append(this.toIndentedString(this.orgId)).append("\n");
        sb.append("    trustedAppInstanceId: ").append(this.toIndentedString(this.trustedAppInstanceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

