/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CustomAuthorizationServer;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.ManagedConnectionStatus;
import com.okta.sdk.resource.model.ScopeCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Identity assertion connection for a custom authorization server")
@JsonPropertyOrder(value={"authorizationServer", "connectionType", "id", "orn", "protocolType", "resourceIndicator", "scopeCondition", "scopes", "status", "_links"})
public class IdentityAssertionCustomASConnection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHORIZATION_SERVER = "authorizationServer";
    private CustomAuthorizationServer authorizationServer;
    public static final String JSON_PROPERTY_CONNECTION_TYPE = "connectionType";
    private ConnectionTypeEnum connectionType;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;
    public static final String JSON_PROPERTY_PROTOCOL_TYPE = "protocolType";
    private ProtocolTypeEnum protocolType;
    public static final String JSON_PROPERTY_RESOURCE_INDICATOR = "resourceIndicator";
    private URI resourceIndicator;
    public static final String JSON_PROPERTY_SCOPE_CONDITION = "scopeCondition";
    private ScopeCondition scopeCondition;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ManagedConnectionStatus status;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public IdentityAssertionCustomASConnection authorizationServer(CustomAuthorizationServer authorizationServer) {
        this.authorizationServer = authorizationServer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="authorizationServer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomAuthorizationServer getAuthorizationServer() {
        return this.authorizationServer;
    }

    @JsonProperty(value="authorizationServer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthorizationServer(CustomAuthorizationServer authorizationServer) {
        this.authorizationServer = authorizationServer;
    }

    public IdentityAssertionCustomASConnection connectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of connection authentication method")
    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
    }

    public IdentityAssertionCustomASConnection id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the managed connection. Only present for managed connections.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public IdentityAssertionCustomASConnection orn(String orn) {
        this.orn = orn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The [ORN](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#okta-resource-name-orn) of the managed connection")
    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrn() {
        return this.orn;
    }

    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrn(String orn) {
        this.orn = orn;
    }

    public IdentityAssertionCustomASConnection protocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authentication protocol type used for the connection")
    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolTypeEnum getProtocolType() {
        return this.protocolType;
    }

    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
    }

    public IdentityAssertionCustomASConnection resourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Resource indicator used when requesting tokens.")
    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getResourceIndicator() {
        return this.resourceIndicator;
    }

    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
    }

    public IdentityAssertionCustomASConnection scopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScopeCondition getScopeCondition() {
        return this.scopeCondition;
    }

    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
    }

    public IdentityAssertionCustomASConnection scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public IdentityAssertionCustomASConnection addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of scopes. Required for all `scopeCondition` values. For `ALL_SCOPES`, this array is required with a single value of `*`. For `INCLUDE_ONLY`, only these scopes are allowed. For `EXCLUDE`, all scopes except these are allowed.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public IdentityAssertionCustomASConnection status(ManagedConnectionStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ManagedConnectionStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ManagedConnectionStatus status) {
        this.status = status;
    }

    public IdentityAssertionCustomASConnection links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityAssertionCustomASConnection identityAssertionCustomASConnection = (IdentityAssertionCustomASConnection)o;
        return Objects.equals(this.authorizationServer, identityAssertionCustomASConnection.authorizationServer) && Objects.equals((Object)this.connectionType, (Object)identityAssertionCustomASConnection.connectionType) && Objects.equals(this.id, identityAssertionCustomASConnection.id) && Objects.equals(this.orn, identityAssertionCustomASConnection.orn) && Objects.equals((Object)this.protocolType, (Object)identityAssertionCustomASConnection.protocolType) && Objects.equals(this.resourceIndicator, identityAssertionCustomASConnection.resourceIndicator) && Objects.equals((Object)this.scopeCondition, (Object)identityAssertionCustomASConnection.scopeCondition) && Objects.equals(this.scopes, identityAssertionCustomASConnection.scopes) && Objects.equals((Object)this.status, (Object)identityAssertionCustomASConnection.status) && Objects.equals(this.links, identityAssertionCustomASConnection.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationServer, this.connectionType, this.id, this.orn, this.protocolType, this.resourceIndicator, this.scopeCondition, this.scopes, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityAssertionCustomASConnection {\n");
        sb.append("    authorizationServer: ").append(this.toIndentedString(this.authorizationServer)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    orn: ").append(this.toIndentedString(this.orn)).append("\n");
        sb.append("    protocolType: ").append(this.toIndentedString((Object)this.protocolType)).append("\n");
        sb.append("    resourceIndicator: ").append(this.toIndentedString(this.resourceIndicator)).append("\n");
        sb.append("    scopeCondition: ").append(this.toIndentedString((Object)this.scopeCondition)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionTypeEnum {
        IDENTITY_ASSERTION_CUSTOM_AS(String.valueOf("IDENTITY_ASSERTION_CUSTOM_AS")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionTypeEnum fromValue(String value) {
            for (ConnectionTypeEnum b : ConnectionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ProtocolTypeEnum {
        IDENTITY_ASSERTION(String.valueOf("IDENTITY_ASSERTION")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ProtocolTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolTypeEnum fromValue(String value) {
            for (ProtocolTypeEnum b : ProtocolTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

