/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AppConfig;
import com.okta.sdk.resource.model.GroupPushMappingLinks;
import com.okta.sdk.resource.model.GroupPushMappingStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"appConfig", "created", "errorSummary", "id", "lastPush", "lastUpdated", "sourceGroupId", "status", "targetGroupId", "_links"})
public class GroupPushMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP_CONFIG = "appConfig";
    private AppConfig appConfig;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ERROR_SUMMARY = "errorSummary";
    private String errorSummary;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_PUSH = "lastPush";
    private OffsetDateTime lastPush;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_SOURCE_GROUP_ID = "sourceGroupId";
    private String sourceGroupId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private GroupPushMappingStatus status;
    public static final String JSON_PROPERTY_TARGET_GROUP_ID = "targetGroupId";
    private String targetGroupId;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private GroupPushMappingLinks links;

    public GroupPushMapping appConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="appConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @JsonProperty(value="appConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the group push mapping was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="The error message summary if the latest push failed")
    @JsonProperty(value="errorSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorSummary() {
        return this.errorSummary;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the group push mapping")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the group push mapping was pushed")
    @JsonProperty(value="lastPush")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastPush() {
        return this.lastPush;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the group push mapping was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the source group for the group push mapping")
    @JsonProperty(value="sourceGroupId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceGroupId() {
        return this.sourceGroupId;
    }

    public GroupPushMapping status(GroupPushMappingStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupPushMappingStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(GroupPushMappingStatus status) {
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the target group for the group push mapping")
    @JsonProperty(value="targetGroupId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetGroupId() {
        return this.targetGroupId;
    }

    public GroupPushMapping links(GroupPushMappingLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupPushMappingLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(GroupPushMappingLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupPushMapping groupPushMapping = (GroupPushMapping)o;
        return Objects.equals(this.appConfig, groupPushMapping.appConfig) && Objects.equals(this.created, groupPushMapping.created) && Objects.equals(this.errorSummary, groupPushMapping.errorSummary) && Objects.equals(this.id, groupPushMapping.id) && Objects.equals(this.lastPush, groupPushMapping.lastPush) && Objects.equals(this.lastUpdated, groupPushMapping.lastUpdated) && Objects.equals(this.sourceGroupId, groupPushMapping.sourceGroupId) && Objects.equals((Object)this.status, (Object)groupPushMapping.status) && Objects.equals(this.targetGroupId, groupPushMapping.targetGroupId) && Objects.equals(this.links, groupPushMapping.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appConfig, this.created, this.errorSummary, this.id, this.lastPush, this.lastUpdated, this.sourceGroupId, this.status, this.targetGroupId, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupPushMapping {\n");
        sb.append("    appConfig: ").append(this.toIndentedString(this.appConfig)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    errorSummary: ").append(this.toIndentedString(this.errorSummary)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastPush: ").append(this.toIndentedString(this.lastPush)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    sourceGroupId: ").append(this.toIndentedString(this.sourceGroupId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    targetGroupId: ").append(this.toIndentedString(this.targetGroupId)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

