/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.FulfillmentDataOrderDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fulfillment request")
@JsonPropertyOrder(value={"fulfillmentData", "fulfillmentProvider", "userId"})
public class FulfillmentRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_FULFILLMENT_DATA = "fulfillmentData";
    private List<FulfillmentDataOrderDetails> fulfillmentData = null;
    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public FulfillmentRequest fulfillmentData(List<FulfillmentDataOrderDetails> fulfillmentData) {
        this.fulfillmentData = fulfillmentData;
        return this;
    }

    public FulfillmentRequest addfulfillmentDataItem(FulfillmentDataOrderDetails fulfillmentDataItem) {
        if (this.fulfillmentData == null) {
            this.fulfillmentData = new ArrayList<FulfillmentDataOrderDetails>();
        }
        this.fulfillmentData.add(fulfillmentDataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of fulfillment order details")
    @JsonProperty(value="fulfillmentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FulfillmentDataOrderDetails> getFulfillmentData() {
        return this.fulfillmentData;
    }

    @JsonProperty(value="fulfillmentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentData(List<FulfillmentDataOrderDetails> fulfillmentData) {
        this.fulfillmentData = fulfillmentData;
    }

    public FulfillmentRequest fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the fulfillment provider for the WebAuthn preregistration factor")
    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FulfillmentProviderEnum getFulfillmentProvider() {
        return this.fulfillmentProvider;
    }

    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public FulfillmentRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of an existing Okta user")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentRequest fulfillmentRequest = (FulfillmentRequest)o;
        return Objects.equals(this.fulfillmentData, fulfillmentRequest.fulfillmentData) && Objects.equals((Object)this.fulfillmentProvider, (Object)fulfillmentRequest.fulfillmentProvider) && Objects.equals(this.userId, fulfillmentRequest.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fulfillmentData, this.fulfillmentProvider, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentRequest {\n");
        sb.append("    fulfillmentData: ").append(this.toIndentedString(this.fulfillmentData)).append("\n");
        sb.append("    fulfillmentProvider: ").append(this.toIndentedString((Object)this.fulfillmentProvider)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FulfillmentProviderEnum {
        YUBICO(String.valueOf("yubico")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

