/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.NetworkZone;
import com.okta.sdk.resource.model.NetworkZoneLocation;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"asns", "proxyType", "locations"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=DynamicNetworkZone.class)
public class DynamicNetworkZone
extends NetworkZone
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ASNS = "asns";
    private List<String> asns = null;
    public static final String JSON_PROPERTY_PROXY_TYPE = "proxyType";
    private ProxyTypeEnum proxyType;
    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private JsonNullable<List<NetworkZoneLocation>> locations = JsonNullable.undefined();

    public DynamicNetworkZone asns(List<String> asns) {
        this.asns = asns;
        return this;
    }

    public DynamicNetworkZone addasnsItem(String asnsItem) {
        if (this.asns == null) {
            this.asns = new ArrayList<String>();
        }
        this.asns.add(asnsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of ASNs for a Network Zone")
    @JsonProperty(value="asns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAsns() {
        return this.asns;
    }

    @JsonProperty(value="asns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsns(List<String> asns) {
        this.asns = asns;
    }

    public DynamicNetworkZone proxyType(ProxyTypeEnum proxyType) {
        this.proxyType = proxyType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The proxy type used for a Dynamic Network Zone")
    @JsonProperty(value="proxyType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProxyTypeEnum getProxyType() {
        return this.proxyType;
    }

    @JsonProperty(value="proxyType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProxyType(ProxyTypeEnum proxyType) {
        this.proxyType = proxyType;
    }

    public DynamicNetworkZone locations(List<NetworkZoneLocation> locations) {
        this.locations = JsonNullable.of(locations);
        return this;
    }

    public DynamicNetworkZone addlocationsItem(NetworkZoneLocation locationsItem) {
        if (this.locations == null || !this.locations.isPresent()) {
            this.locations = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.locations.get()).add(locationsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of geolocations for a Dynamic Network Zone")
    @JsonIgnore
    public List<NetworkZoneLocation> getLocations() {
        return (List)this.locations.orElse(null);
    }

    @JsonProperty(value="locations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<NetworkZoneLocation>> getLocations_JsonNullable() {
        return this.locations;
    }

    @JsonProperty(value="locations")
    public void setLocations_JsonNullable(JsonNullable<List<NetworkZoneLocation>> locations) {
        this.locations = locations;
    }

    public void setLocations(List<NetworkZoneLocation> locations) {
        this.locations = JsonNullable.of(locations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicNetworkZone dynamicNetworkZone = (DynamicNetworkZone)o;
        return Objects.equals(this.asns, dynamicNetworkZone.asns) && Objects.equals((Object)this.proxyType, (Object)dynamicNetworkZone.proxyType) && DynamicNetworkZone.equalsNullable(this.locations, dynamicNetworkZone.locations) && super.equals(o);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.asns, this.proxyType, DynamicNetworkZone.hashCodeNullable(this.locations), super.hashCode()});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DynamicNetworkZone {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    asns: ").append(this.toIndentedString(this.asns)).append("\n");
        sb.append("    proxyType: ").append(this.toIndentedString((Object)this.proxyType)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString(this.locations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProxyTypeEnum {
        NULL(String.valueOf("null")),
        ANY(String.valueOf("Any")),
        TOR(String.valueOf("Tor")),
        NOT_TOR_ANONYMIZER(String.valueOf("NotTorAnonymizer")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ProxyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProxyTypeEnum fromValue(String value) {
            for (ProxyTypeEnum b : ProxyTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

