/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "key", "userIdentification"})
public class DeviceContextProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_KEY = "key";
    private KeyEnum key;
    public static final String JSON_PROPERTY_USER_IDENTIFICATION = "userIdentification";
    private UserIdentificationEnum userIdentification;

    public DeviceContextProvider id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the device context provider")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public DeviceContextProvider key(KeyEnum key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifies the type of device context provider")
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public KeyEnum getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKey(KeyEnum key) {
        this.key = key;
    }

    public DeviceContextProvider userIdentification(UserIdentificationEnum userIdentification) {
        this.userIdentification = userIdentification;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the device context provider is used to identify the user. `IGNORE` prevents the device context provider from being used to authenticate the user. Identification of the device and device context collection happens regardless of this setting.")
    @JsonProperty(value="userIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserIdentificationEnum getUserIdentification() {
        return this.userIdentification;
    }

    @JsonProperty(value="userIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserIdentification(UserIdentificationEnum userIdentification) {
        this.userIdentification = userIdentification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceContextProvider deviceContextProvider = (DeviceContextProvider)o;
        return Objects.equals(this.id, deviceContextProvider.id) && Objects.equals((Object)this.key, (Object)deviceContextProvider.key) && Objects.equals((Object)this.userIdentification, (Object)deviceContextProvider.userIdentification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.key, this.userIdentification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceContextProvider {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString((Object)this.key)).append("\n");
        sb.append("    userIdentification: ").append(this.toIndentedString((Object)this.userIdentification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KeyEnum {
        OKTA_VERIFY(String.valueOf("OKTA_VERIFY")),
        CHROME_DEVICE_TRUST(String.valueOf("CHROME_DEVICE_TRUST")),
        DEVICE_POSTURE_IDP(String.valueOf("DEVICE_POSTURE_IDP")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private KeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KeyEnum fromValue(String value) {
            for (KeyEnum b : KeyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UserIdentificationEnum {
        ALLOW(String.valueOf("ALLOW")),
        IGNORE(String.valueOf("IGNORE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UserIdentificationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserIdentificationEnum fromValue(String value) {
            for (UserIdentificationEnum b : UserIdentificationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

