/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ChromeBrowserVersion;
import com.okta.sdk.resource.model.KeyTrustLevelBrowserKey;
import com.okta.sdk.resource.model.OSVersionFourComponents;
import com.okta.sdk.resource.model.PasswordProtectionWarningTrigger;
import com.okta.sdk.resource.model.SafeBrowsingProtectionLevel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Google Chrome Device Trust Connector provider")
@JsonPropertyOrder(value={"antivirusEnabled", "browserVersion", "builtInDnsClientEnabled", "chromeRemoteDesktopAppBlocked", "crowdStrikeAgentId", "crowdStrikeCustomerId", "deviceEnrollmentDomain", "diskEncrypted", "keyTrustLevel", "osFirewall", "osVersion", "passwordProtectionWarningTrigger", "realtimeUrlCheckMode", "safeBrowsingProtectionLevel", "screenLockSecured", "secureBootEnabled", "siteIsolationEnabled", "thirdPartyBlockingEnabled", "windowsMachineDomain", "windowsUserDomain"})
public class DTCWindows
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ANTIVIRUS_ENABLED = "antivirusEnabled";
    private Boolean antivirusEnabled;
    public static final String JSON_PROPERTY_BROWSER_VERSION = "browserVersion";
    private ChromeBrowserVersion browserVersion;
    public static final String JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED = "builtInDnsClientEnabled";
    private Boolean builtInDnsClientEnabled;
    public static final String JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED = "chromeRemoteDesktopAppBlocked";
    private Boolean chromeRemoteDesktopAppBlocked;
    public static final String JSON_PROPERTY_CROWD_STRIKE_AGENT_ID = "crowdStrikeAgentId";
    private String crowdStrikeAgentId;
    public static final String JSON_PROPERTY_CROWD_STRIKE_CUSTOMER_ID = "crowdStrikeCustomerId";
    private String crowdStrikeCustomerId;
    public static final String JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN = "deviceEnrollmentDomain";
    private String deviceEnrollmentDomain;
    public static final String JSON_PROPERTY_DISK_ENCRYPTED = "diskEncrypted";
    private Boolean diskEncrypted;
    public static final String JSON_PROPERTY_KEY_TRUST_LEVEL = "keyTrustLevel";
    private KeyTrustLevelBrowserKey keyTrustLevel;
    public static final String JSON_PROPERTY_OS_FIREWALL = "osFirewall";
    private Boolean osFirewall;
    public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
    private OSVersionFourComponents osVersion;
    public static final String JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER = "passwordProtectionWarningTrigger";
    private PasswordProtectionWarningTrigger passwordProtectionWarningTrigger;
    public static final String JSON_PROPERTY_REALTIME_URL_CHECK_MODE = "realtimeUrlCheckMode";
    private Boolean realtimeUrlCheckMode;
    public static final String JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL = "safeBrowsingProtectionLevel";
    private SafeBrowsingProtectionLevel safeBrowsingProtectionLevel;
    public static final String JSON_PROPERTY_SCREEN_LOCK_SECURED = "screenLockSecured";
    private Boolean screenLockSecured;
    public static final String JSON_PROPERTY_SECURE_BOOT_ENABLED = "secureBootEnabled";
    private Boolean secureBootEnabled;
    public static final String JSON_PROPERTY_SITE_ISOLATION_ENABLED = "siteIsolationEnabled";
    private Boolean siteIsolationEnabled;
    public static final String JSON_PROPERTY_THIRD_PARTY_BLOCKING_ENABLED = "thirdPartyBlockingEnabled";
    private Boolean thirdPartyBlockingEnabled;
    public static final String JSON_PROPERTY_WINDOWS_MACHINE_DOMAIN = "windowsMachineDomain";
    private String windowsMachineDomain;
    public static final String JSON_PROPERTY_WINDOWS_USER_DOMAIN = "windowsUserDomain";
    private String windowsUserDomain;

    public DTCWindows antivirusEnabled(Boolean antivirusEnabled) {
        this.antivirusEnabled = antivirusEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="<x-lifecycle-container><x-lifecycle class=\"ea\"></x-lifecycle></x-lifecycle-container>Indicates whether antivirus software is enabled")
    @JsonProperty(value="antivirusEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAntivirusEnabled() {
        return this.antivirusEnabled;
    }

    @JsonProperty(value="antivirusEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAntivirusEnabled(Boolean antivirusEnabled) {
        this.antivirusEnabled = antivirusEnabled;
    }

    public DTCWindows browserVersion(ChromeBrowserVersion browserVersion) {
        this.browserVersion = browserVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="browserVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChromeBrowserVersion getBrowserVersion() {
        return this.browserVersion;
    }

    @JsonProperty(value="browserVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrowserVersion(ChromeBrowserVersion browserVersion) {
        this.browserVersion = browserVersion;
    }

    public DTCWindows builtInDnsClientEnabled(Boolean builtInDnsClientEnabled) {
        this.builtInDnsClientEnabled = builtInDnsClientEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if a software stack is used to communicate with the DNS server")
    @JsonProperty(value="builtInDnsClientEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBuiltInDnsClientEnabled() {
        return this.builtInDnsClientEnabled;
    }

    @JsonProperty(value="builtInDnsClientEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBuiltInDnsClientEnabled(Boolean builtInDnsClientEnabled) {
        this.builtInDnsClientEnabled = builtInDnsClientEnabled;
    }

    public DTCWindows chromeRemoteDesktopAppBlocked(Boolean chromeRemoteDesktopAppBlocked) {
        this.chromeRemoteDesktopAppBlocked = chromeRemoteDesktopAppBlocked;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether access to the Chrome Remote Desktop application is blocked through a policy")
    @JsonProperty(value="chromeRemoteDesktopAppBlocked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getChromeRemoteDesktopAppBlocked() {
        return this.chromeRemoteDesktopAppBlocked;
    }

    @JsonProperty(value="chromeRemoteDesktopAppBlocked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChromeRemoteDesktopAppBlocked(Boolean chromeRemoteDesktopAppBlocked) {
        this.chromeRemoteDesktopAppBlocked = chromeRemoteDesktopAppBlocked;
    }

    public DTCWindows crowdStrikeAgentId(String crowdStrikeAgentId) {
        this.crowdStrikeAgentId = crowdStrikeAgentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Agent ID of an installed CrowdStrike agent")
    @JsonProperty(value="crowdStrikeAgentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCrowdStrikeAgentId() {
        return this.crowdStrikeAgentId;
    }

    @JsonProperty(value="crowdStrikeAgentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCrowdStrikeAgentId(String crowdStrikeAgentId) {
        this.crowdStrikeAgentId = crowdStrikeAgentId;
    }

    public DTCWindows crowdStrikeCustomerId(String crowdStrikeCustomerId) {
        this.crowdStrikeCustomerId = crowdStrikeCustomerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Customer ID of an installed CrowdStrike agent")
    @JsonProperty(value="crowdStrikeCustomerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCrowdStrikeCustomerId() {
        return this.crowdStrikeCustomerId;
    }

    @JsonProperty(value="crowdStrikeCustomerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCrowdStrikeCustomerId(String crowdStrikeCustomerId) {
        this.crowdStrikeCustomerId = crowdStrikeCustomerId;
    }

    public DTCWindows deviceEnrollmentDomain(String deviceEnrollmentDomain) {
        this.deviceEnrollmentDomain = deviceEnrollmentDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Enrollment domain of the customer that is currently managing the device")
    @JsonProperty(value="deviceEnrollmentDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceEnrollmentDomain() {
        return this.deviceEnrollmentDomain;
    }

    @JsonProperty(value="deviceEnrollmentDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceEnrollmentDomain(String deviceEnrollmentDomain) {
        this.deviceEnrollmentDomain = deviceEnrollmentDomain;
    }

    public DTCWindows diskEncrypted(Boolean diskEncrypted) {
        this.diskEncrypted = diskEncrypted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the main disk is encrypted")
    @JsonProperty(value="diskEncrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDiskEncrypted() {
        return this.diskEncrypted;
    }

    @JsonProperty(value="diskEncrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiskEncrypted(Boolean diskEncrypted) {
        this.diskEncrypted = diskEncrypted;
    }

    public DTCWindows keyTrustLevel(KeyTrustLevelBrowserKey keyTrustLevel) {
        this.keyTrustLevel = keyTrustLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="keyTrustLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyTrustLevelBrowserKey getKeyTrustLevel() {
        return this.keyTrustLevel;
    }

    @JsonProperty(value="keyTrustLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyTrustLevel(KeyTrustLevelBrowserKey keyTrustLevel) {
        this.keyTrustLevel = keyTrustLevel;
    }

    public DTCWindows osFirewall(Boolean osFirewall) {
        this.osFirewall = osFirewall;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether a firewall is enabled at the OS-level on the device")
    @JsonProperty(value="osFirewall")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOsFirewall() {
        return this.osFirewall;
    }

    @JsonProperty(value="osFirewall")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOsFirewall(Boolean osFirewall) {
        this.osFirewall = osFirewall;
    }

    public DTCWindows osVersion(OSVersionFourComponents osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="osVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OSVersionFourComponents getOsVersion() {
        return this.osVersion;
    }

    @JsonProperty(value="osVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOsVersion(OSVersionFourComponents osVersion) {
        this.osVersion = osVersion;
    }

    public DTCWindows passwordProtectionWarningTrigger(PasswordProtectionWarningTrigger passwordProtectionWarningTrigger) {
        this.passwordProtectionWarningTrigger = passwordProtectionWarningTrigger;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="passwordProtectionWarningTrigger")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PasswordProtectionWarningTrigger getPasswordProtectionWarningTrigger() {
        return this.passwordProtectionWarningTrigger;
    }

    @JsonProperty(value="passwordProtectionWarningTrigger")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordProtectionWarningTrigger(PasswordProtectionWarningTrigger passwordProtectionWarningTrigger) {
        this.passwordProtectionWarningTrigger = passwordProtectionWarningTrigger;
    }

    public DTCWindows realtimeUrlCheckMode(Boolean realtimeUrlCheckMode) {
        this.realtimeUrlCheckMode = realtimeUrlCheckMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether enterprise-grade (custom) unsafe URL scanning is enabled")
    @JsonProperty(value="realtimeUrlCheckMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRealtimeUrlCheckMode() {
        return this.realtimeUrlCheckMode;
    }

    @JsonProperty(value="realtimeUrlCheckMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRealtimeUrlCheckMode(Boolean realtimeUrlCheckMode) {
        this.realtimeUrlCheckMode = realtimeUrlCheckMode;
    }

    public DTCWindows safeBrowsingProtectionLevel(SafeBrowsingProtectionLevel safeBrowsingProtectionLevel) {
        this.safeBrowsingProtectionLevel = safeBrowsingProtectionLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="safeBrowsingProtectionLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SafeBrowsingProtectionLevel getSafeBrowsingProtectionLevel() {
        return this.safeBrowsingProtectionLevel;
    }

    @JsonProperty(value="safeBrowsingProtectionLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSafeBrowsingProtectionLevel(SafeBrowsingProtectionLevel safeBrowsingProtectionLevel) {
        this.safeBrowsingProtectionLevel = safeBrowsingProtectionLevel;
    }

    public DTCWindows screenLockSecured(Boolean screenLockSecured) {
        this.screenLockSecured = screenLockSecured;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the device is password-protected")
    @JsonProperty(value="screenLockSecured")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getScreenLockSecured() {
        return this.screenLockSecured;
    }

    @JsonProperty(value="screenLockSecured")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockSecured(Boolean screenLockSecured) {
        this.screenLockSecured = screenLockSecured;
    }

    public DTCWindows secureBootEnabled(Boolean secureBootEnabled) {
        this.secureBootEnabled = secureBootEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the device's startup software has its Secure Boot feature enabled")
    @JsonProperty(value="secureBootEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSecureBootEnabled() {
        return this.secureBootEnabled;
    }

    @JsonProperty(value="secureBootEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecureBootEnabled(Boolean secureBootEnabled) {
        this.secureBootEnabled = secureBootEnabled;
    }

    public DTCWindows siteIsolationEnabled(Boolean siteIsolationEnabled) {
        this.siteIsolationEnabled = siteIsolationEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the Site Isolation (also known as **Site Per Process**) setting is enabled")
    @JsonProperty(value="siteIsolationEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSiteIsolationEnabled() {
        return this.siteIsolationEnabled;
    }

    @JsonProperty(value="siteIsolationEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSiteIsolationEnabled(Boolean siteIsolationEnabled) {
        this.siteIsolationEnabled = siteIsolationEnabled;
    }

    public DTCWindows thirdPartyBlockingEnabled(Boolean thirdPartyBlockingEnabled) {
        this.thirdPartyBlockingEnabled = thirdPartyBlockingEnabled;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="Indicates whether Chrome is blocking third-party software injection")
    @JsonProperty(value="thirdPartyBlockingEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getThirdPartyBlockingEnabled() {
        return this.thirdPartyBlockingEnabled;
    }

    @JsonProperty(value="thirdPartyBlockingEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThirdPartyBlockingEnabled(Boolean thirdPartyBlockingEnabled) {
        this.thirdPartyBlockingEnabled = thirdPartyBlockingEnabled;
    }

    public DTCWindows windowsMachineDomain(String windowsMachineDomain) {
        this.windowsMachineDomain = windowsMachineDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Windows domain that the current machine has joined")
    @JsonProperty(value="windowsMachineDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWindowsMachineDomain() {
        return this.windowsMachineDomain;
    }

    @JsonProperty(value="windowsMachineDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWindowsMachineDomain(String windowsMachineDomain) {
        this.windowsMachineDomain = windowsMachineDomain;
    }

    public DTCWindows windowsUserDomain(String windowsUserDomain) {
        this.windowsUserDomain = windowsUserDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Windows domain for the current OS user")
    @JsonProperty(value="windowsUserDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWindowsUserDomain() {
        return this.windowsUserDomain;
    }

    @JsonProperty(value="windowsUserDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWindowsUserDomain(String windowsUserDomain) {
        this.windowsUserDomain = windowsUserDomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DTCWindows dtCWindows = (DTCWindows)o;
        return Objects.equals(this.antivirusEnabled, dtCWindows.antivirusEnabled) && Objects.equals(this.browserVersion, dtCWindows.browserVersion) && Objects.equals(this.builtInDnsClientEnabled, dtCWindows.builtInDnsClientEnabled) && Objects.equals(this.chromeRemoteDesktopAppBlocked, dtCWindows.chromeRemoteDesktopAppBlocked) && Objects.equals(this.crowdStrikeAgentId, dtCWindows.crowdStrikeAgentId) && Objects.equals(this.crowdStrikeCustomerId, dtCWindows.crowdStrikeCustomerId) && Objects.equals(this.deviceEnrollmentDomain, dtCWindows.deviceEnrollmentDomain) && Objects.equals(this.diskEncrypted, dtCWindows.diskEncrypted) && Objects.equals((Object)this.keyTrustLevel, (Object)dtCWindows.keyTrustLevel) && Objects.equals(this.osFirewall, dtCWindows.osFirewall) && Objects.equals(this.osVersion, dtCWindows.osVersion) && Objects.equals((Object)this.passwordProtectionWarningTrigger, (Object)dtCWindows.passwordProtectionWarningTrigger) && Objects.equals(this.realtimeUrlCheckMode, dtCWindows.realtimeUrlCheckMode) && Objects.equals((Object)this.safeBrowsingProtectionLevel, (Object)dtCWindows.safeBrowsingProtectionLevel) && Objects.equals(this.screenLockSecured, dtCWindows.screenLockSecured) && Objects.equals(this.secureBootEnabled, dtCWindows.secureBootEnabled) && Objects.equals(this.siteIsolationEnabled, dtCWindows.siteIsolationEnabled) && Objects.equals(this.thirdPartyBlockingEnabled, dtCWindows.thirdPartyBlockingEnabled) && Objects.equals(this.windowsMachineDomain, dtCWindows.windowsMachineDomain) && Objects.equals(this.windowsUserDomain, dtCWindows.windowsUserDomain);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.antivirusEnabled, this.browserVersion, this.builtInDnsClientEnabled, this.chromeRemoteDesktopAppBlocked, this.crowdStrikeAgentId, this.crowdStrikeCustomerId, this.deviceEnrollmentDomain, this.diskEncrypted, this.keyTrustLevel, this.osFirewall, this.osVersion, this.passwordProtectionWarningTrigger, this.realtimeUrlCheckMode, this.safeBrowsingProtectionLevel, this.screenLockSecured, this.secureBootEnabled, this.siteIsolationEnabled, this.thirdPartyBlockingEnabled, this.windowsMachineDomain, this.windowsUserDomain});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DTCWindows {\n");
        sb.append("    antivirusEnabled: ").append(this.toIndentedString(this.antivirusEnabled)).append("\n");
        sb.append("    browserVersion: ").append(this.toIndentedString(this.browserVersion)).append("\n");
        sb.append("    builtInDnsClientEnabled: ").append(this.toIndentedString(this.builtInDnsClientEnabled)).append("\n");
        sb.append("    chromeRemoteDesktopAppBlocked: ").append(this.toIndentedString(this.chromeRemoteDesktopAppBlocked)).append("\n");
        sb.append("    crowdStrikeAgentId: ").append(this.toIndentedString(this.crowdStrikeAgentId)).append("\n");
        sb.append("    crowdStrikeCustomerId: ").append(this.toIndentedString(this.crowdStrikeCustomerId)).append("\n");
        sb.append("    deviceEnrollmentDomain: ").append(this.toIndentedString(this.deviceEnrollmentDomain)).append("\n");
        sb.append("    diskEncrypted: ").append(this.toIndentedString(this.diskEncrypted)).append("\n");
        sb.append("    keyTrustLevel: ").append(this.toIndentedString((Object)this.keyTrustLevel)).append("\n");
        sb.append("    osFirewall: ").append(this.toIndentedString(this.osFirewall)).append("\n");
        sb.append("    osVersion: ").append(this.toIndentedString(this.osVersion)).append("\n");
        sb.append("    passwordProtectionWarningTrigger: ").append(this.toIndentedString((Object)this.passwordProtectionWarningTrigger)).append("\n");
        sb.append("    realtimeUrlCheckMode: ").append(this.toIndentedString(this.realtimeUrlCheckMode)).append("\n");
        sb.append("    safeBrowsingProtectionLevel: ").append(this.toIndentedString((Object)this.safeBrowsingProtectionLevel)).append("\n");
        sb.append("    screenLockSecured: ").append(this.toIndentedString(this.screenLockSecured)).append("\n");
        sb.append("    secureBootEnabled: ").append(this.toIndentedString(this.secureBootEnabled)).append("\n");
        sb.append("    siteIsolationEnabled: ").append(this.toIndentedString(this.siteIsolationEnabled)).append("\n");
        sb.append("    thirdPartyBlockingEnabled: ").append(this.toIndentedString(this.thirdPartyBlockingEnabled)).append("\n");
        sb.append("    windowsMachineDomain: ").append(this.toIndentedString(this.windowsMachineDomain)).append("\n");
        sb.append("    windowsUserDomain: ").append(this.toIndentedString(this.windowsUserDomain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

