/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.DNSRecordTypeAuthenticators;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DNS TXT record that must be registered for an RP ID domain that requires verification. This is used to verify the domain ownership for the WebAuthn RP ID configuration. After the domain ownership is verified, the `DNSRecord` isn't returned in the response.")
@JsonPropertyOrder(value={"fqdn", "recordType", "verificationValue"})
public class DNSRecordAuthenticators
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_FQDN = "fqdn";
    private String fqdn;
    public static final String JSON_PROPERTY_RECORD_TYPE = "recordType";
    private DNSRecordTypeAuthenticators recordType;
    public static final String JSON_PROPERTY_VERIFICATION_VALUE = "verificationValue";
    private String verificationValue;

    public DNSRecordAuthenticators fqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="_oktaverification.mycustomdomain.com", value="The DNS record name")
    @JsonProperty(value="fqdn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFqdn() {
        return this.fqdn;
    }

    @JsonProperty(value="fqdn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFqdn(String fqdn) {
        this.fqdn = fqdn;
    }

    public DNSRecordAuthenticators recordType(DNSRecordTypeAuthenticators recordType) {
        this.recordType = recordType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="recordType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DNSRecordTypeAuthenticators getRecordType() {
        return this.recordType;
    }

    @JsonProperty(value="recordType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecordType(DNSRecordTypeAuthenticators recordType) {
        this.recordType = recordType;
    }

    public DNSRecordAuthenticators verificationValue(String verificationValue) {
        this.verificationValue = verificationValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"79496f234c814638b1cc44f51a782781\"]", value="The DNS record verification value")
    @JsonProperty(value="verificationValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationValue() {
        return this.verificationValue;
    }

    @JsonProperty(value="verificationValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationValue(String verificationValue) {
        this.verificationValue = verificationValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSRecordAuthenticators dnSRecordAuthenticators = (DNSRecordAuthenticators)o;
        return Objects.equals(this.fqdn, dnSRecordAuthenticators.fqdn) && Objects.equals((Object)this.recordType, (Object)dnSRecordAuthenticators.recordType) && Objects.equals(this.verificationValue, dnSRecordAuthenticators.verificationValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fqdn, this.recordType, this.verificationValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DNSRecordAuthenticators {\n");
        sb.append("    fqdn: ").append(this.toIndentedString(this.fqdn)).append("\n");
        sb.append("    recordType: ").append(this.toIndentedString((Object)this.recordType)).append("\n");
        sb.append("    verificationValue: ").append(this.toIndentedString(this.verificationValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

