/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"resource-set", "role", "type"})
public class CustomRoleAssignmentSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_RESOURCE_SET = "resource-set";
    private String resourceSet;
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public CustomRoleAssignmentSchema resourceSet(String resourceSet) {
        this.resourceSet = resourceSet;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Resource set ID")
    @JsonProperty(value="resource-set")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getResourceSet() {
        return this.resourceSet;
    }

    @JsonProperty(value="resource-set")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResourceSet(String resourceSet) {
        this.resourceSet = resourceSet;
    }

    public CustomRoleAssignmentSchema role(String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Custom role ID")
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRole(String role) {
        this.role = role;
    }

    public CustomRoleAssignmentSchema type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Specify a [standard admin role](/openapi/okta-management/guides/roles/#standard-roles), an [IAM-based standard role](/openapi/okta-management/guides/roles/#iam-based-standard-roles), or `CUSTOM` for a custom role type:")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomRoleAssignmentSchema customRoleAssignmentSchema = (CustomRoleAssignmentSchema)o;
        return Objects.equals(this.resourceSet, customRoleAssignmentSchema.resourceSet) && Objects.equals(this.role, customRoleAssignmentSchema.role) && Objects.equals((Object)this.type, (Object)customRoleAssignmentSchema.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceSet, this.role, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomRoleAssignmentSchema {\n");
        sb.append("    resourceSet: ").append(this.toIndentedString(this.resourceSet)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CUSTOM(String.valueOf("CUSTOM")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

