/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.CustomAuthorizationServerLinks;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Custom authorization server for the managed connection")
@JsonPropertyOrder(value={"issuerUrl", "logo", "name", "orn", "_links"})
public class CustomAuthorizationServer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ISSUER_URL = "issuerUrl";
    private String issuerUrl;
    public static final String JSON_PROPERTY_LOGO = "logo";
    private String logo;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private CustomAuthorizationServerLinks links;

    public CustomAuthorizationServer issuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Issuer URL for the authorization server")
    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    public CustomAuthorizationServer logo(String logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image URL for the authorization server")
    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogo() {
        return this.logo;
    }

    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(String logo) {
        this.logo = logo;
    }

    public CustomAuthorizationServer name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Display name of the authorization server")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CustomAuthorizationServer orn(String orn) {
        this.orn = orn;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The [ORN](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#okta-resource-name-orn) of the authorization server")
    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOrn() {
        return this.orn;
    }

    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrn(String orn) {
        this.orn = orn;
    }

    public CustomAuthorizationServer links(CustomAuthorizationServerLinks links) {
        this.links = links;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomAuthorizationServerLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLinks(CustomAuthorizationServerLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomAuthorizationServer customAuthorizationServer = (CustomAuthorizationServer)o;
        return Objects.equals(this.issuerUrl, customAuthorizationServer.issuerUrl) && Objects.equals(this.logo, customAuthorizationServer.logo) && Objects.equals(this.name, customAuthorizationServer.name) && Objects.equals(this.orn, customAuthorizationServer.orn) && Objects.equals(this.links, customAuthorizationServer.links);
    }

    public int hashCode() {
        return Objects.hash(this.issuerUrl, this.logo, this.name, this.orn, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomAuthorizationServer {\n");
        sb.append("    issuerUrl: ").append(this.toIndentedString(this.issuerUrl)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orn: ").append(this.toIndentedString(this.orn)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

