/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.okta.sdk.resource.model.SessionIdentityProvider;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details of the user session")
@JsonPropertyOrder(value={"id", "userId", "login", "createdAt", "expiresAt", "status", "lastPasswordVerification", "amr", "idp", "mfaActive"})
@JsonTypeName(value="BaseContext_session")
public class BaseContextSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_LAST_PASSWORD_VERIFICATION = "lastPasswordVerification";
    private OffsetDateTime lastPasswordVerification;
    public static final String JSON_PROPERTY_AMR = "amr";
    private List<String> amr = null;
    public static final String JSON_PROPERTY_IDP = "idp";
    private SessionIdentityProvider idp;
    public static final String JSON_PROPERTY_MFA_ACTIVE = "mfaActive";
    private Boolean mfaActive;

    public BaseContextSession id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="102LN9Bnuc4S_ewfc9BYwageA", value="The unique identifier for the user's session")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public BaseContextSession userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00uq8tMo3zV0OfJON0g3", value="The unique identifier for the user")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public BaseContextSession login(String login) {
        this.login = login;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user@example.com", value="The username used to identify the user. This is often the user's email address.")
    @JsonProperty(value="login")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogin() {
        return this.login;
    }

    @JsonProperty(value="login")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogin(String login) {
        this.login = login;
    }

    public BaseContextSession createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-03-28T16:45:55Z", value="Timestamp of when the session was created")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public BaseContextSession expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-03-28T21:15:23Z", value="Timestamp of when the session expires")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public BaseContextSession status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Represents the current status of the user's session")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public BaseContextSession lastPasswordVerification(OffsetDateTime lastPasswordVerification) {
        this.lastPasswordVerification = lastPasswordVerification;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-03-28T16:45:55Z", value="Timestamp of when the user was last authenticated")
    @JsonProperty(value="lastPasswordVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastPasswordVerification() {
        return this.lastPasswordVerification;
    }

    @JsonProperty(value="lastPasswordVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastPasswordVerification(OffsetDateTime lastPasswordVerification) {
        this.lastPasswordVerification = lastPasswordVerification;
    }

    public BaseContextSession amr(List<String> amr) {
        this.amr = amr;
        return this;
    }

    public BaseContextSession addamrItem(String amrItem) {
        if (this.amr == null) {
            this.amr = new ArrayList<String>();
        }
        this.amr.add(amrItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authentication method reference")
    @JsonProperty(value="amr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmr() {
        return this.amr;
    }

    @JsonProperty(value="amr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmr(List<String> amr) {
        this.amr = amr;
    }

    public BaseContextSession idp(SessionIdentityProvider idp) {
        this.idp = idp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="idp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SessionIdentityProvider getIdp() {
        return this.idp;
    }

    @JsonProperty(value="idp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdp(SessionIdentityProvider idp) {
        this.idp = idp;
    }

    public BaseContextSession mfaActive(Boolean mfaActive) {
        this.mfaActive = mfaActive;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Describes whether multifactor authentication was enabled")
    @JsonProperty(value="mfaActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMfaActive() {
        return this.mfaActive;
    }

    @JsonProperty(value="mfaActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMfaActive(Boolean mfaActive) {
        this.mfaActive = mfaActive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseContextSession baseContextSession = (BaseContextSession)o;
        return Objects.equals(this.id, baseContextSession.id) && Objects.equals(this.userId, baseContextSession.userId) && Objects.equals(this.login, baseContextSession.login) && Objects.equals(this.createdAt, baseContextSession.createdAt) && Objects.equals(this.expiresAt, baseContextSession.expiresAt) && Objects.equals(this.status, baseContextSession.status) && Objects.equals(this.lastPasswordVerification, baseContextSession.lastPasswordVerification) && Objects.equals(this.amr, baseContextSession.amr) && Objects.equals(this.idp, baseContextSession.idp) && Objects.equals(this.mfaActive, baseContextSession.mfaActive);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId, this.login, this.createdAt, this.expiresAt, this.status, this.lastPasswordVerification, this.amr, this.idp, this.mfaActive);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseContextSession {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    lastPasswordVerification: ").append(this.toIndentedString(this.lastPasswordVerification)).append("\n");
        sb.append("    amr: ").append(this.toIndentedString(this.amr)).append("\n");
        sb.append("    idp: ").append(this.toIndentedString(this.idp)).append("\n");
        sb.append("    mfaActive: ").append(this.toIndentedString(this.mfaActive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

