/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the authenticator specific parameters")
@JsonPropertyOrder(value={"expiresAt", "multiUse", "tac"})
public class AuthenticatorProfileTacResponsePost
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_MULTI_USE = "multiUse";
    private Boolean multiUse;
    public static final String JSON_PROPERTY_TAC = "tac";
    private String tac;

    public AuthenticatorProfileTacResponsePost expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when the TAC enrollment expires in the UTC timezone")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public AuthenticatorProfileTacResponsePost multiUse(Boolean multiUse) {
        this.multiUse = multiUse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines whether an enrollment can be used more than once")
    @JsonProperty(value="multiUse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMultiUse() {
        return this.multiUse;
    }

    @JsonProperty(value="multiUse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultiUse(Boolean multiUse) {
        this.multiUse = multiUse;
    }

    public AuthenticatorProfileTacResponsePost tac(String tac) {
        this.tac = tac;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A temporary access code used for authentication. It can be used one or more times and is valid for a defined period specified by the `ttl` property. The `tac` is returned in the response when the enrollment is created. It is not returned when the enrollment is retrieved. Issuing a new TAC invalidates any existing TAC for this user.")
    @JsonProperty(value="tac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTac() {
        return this.tac;
    }

    @JsonProperty(value="tac")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTac(String tac) {
        this.tac = tac;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorProfileTacResponsePost authenticatorProfileTacResponsePost = (AuthenticatorProfileTacResponsePost)o;
        return Objects.equals(this.expiresAt, authenticatorProfileTacResponsePost.expiresAt) && Objects.equals(this.multiUse, authenticatorProfileTacResponsePost.multiUse) && Objects.equals(this.tac, authenticatorProfileTacResponsePost.tac);
    }

    public int hashCode() {
        return Objects.hash(this.expiresAt, this.multiUse, this.tac);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorProfileTacResponsePost {\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    multiUse: ").append(this.toIndentedString(this.multiUse)).append("\n");
        sb.append("    tac: ").append(this.toIndentedString(this.tac)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

