/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.okta.sdk.resource.model.AuthenticatorKeyTacAllOfProviderConfigurationComplexity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Define the configuration settings of the TAC")
@JsonPropertyOrder(value={"minTtl", "maxTtl", "defaultTtl", "length", "complexity", "multiUseAllowed"})
@JsonTypeName(value="AuthenticatorKeyTac_allOf_provider_configuration")
public class AuthenticatorKeyTacAllOfProviderConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_MIN_TTL = "minTtl";
    private BigDecimal minTtl;
    public static final String JSON_PROPERTY_MAX_TTL = "maxTtl";
    private BigDecimal maxTtl;
    public static final String JSON_PROPERTY_DEFAULT_TTL = "defaultTtl";
    private BigDecimal defaultTtl = new BigDecimal("120");
    public static final String JSON_PROPERTY_LENGTH = "length";
    private BigDecimal length;
    public static final String JSON_PROPERTY_COMPLEXITY = "complexity";
    private AuthenticatorKeyTacAllOfProviderConfigurationComplexity complexity;
    public static final String JSON_PROPERTY_MULTI_USE_ALLOWED = "multiUseAllowed";
    private Boolean multiUseAllowed;

    public AuthenticatorKeyTacAllOfProviderConfiguration minTtl(BigDecimal minTtl) {
        this.minTtl = minTtl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Minimum time-to-live (TTL) of the TAC in minutes. The `minTtl` indicates the minimum amount of time that a TAC is valid. The `minTtl` must be less than the `maxTtl`.")
    @JsonProperty(value="minTtl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getMinTtl() {
        return this.minTtl;
    }

    @JsonProperty(value="minTtl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMinTtl(BigDecimal minTtl) {
        this.minTtl = minTtl;
    }

    public AuthenticatorKeyTacAllOfProviderConfiguration maxTtl(BigDecimal maxTtl) {
        this.maxTtl = maxTtl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Maximum TTL of the TAC in minutes. The `maxTtl` indicates the maximum amount of time that a TAC is valid. The `maxTtl` must be greater than the `minTtl`.")
    @JsonProperty(value="maxTtl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getMaxTtl() {
        return this.maxTtl;
    }

    @JsonProperty(value="maxTtl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxTtl(BigDecimal maxTtl) {
        this.maxTtl = maxTtl;
    }

    public AuthenticatorKeyTacAllOfProviderConfiguration defaultTtl(BigDecimal defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The default TTL in minutes when you create a TAC. The `defaultTtl` indicates the actual amount of time that a TAC is valid before it expires. The `defaultTtl` must be greater than the `minTtl` and less than the `maxTtl`.")
    @JsonProperty(value="defaultTtl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getDefaultTtl() {
        return this.defaultTtl;
    }

    @JsonProperty(value="defaultTtl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDefaultTtl(BigDecimal defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public AuthenticatorKeyTacAllOfProviderConfiguration length(BigDecimal length) {
        this.length = length;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Defines the number of characters in a TAC. For example, a `length` of `16` means that the TAC is 16 characters.")
    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public AuthenticatorKeyTacAllOfProviderConfiguration complexity(AuthenticatorKeyTacAllOfProviderConfigurationComplexity complexity) {
        this.complexity = complexity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="complexity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AuthenticatorKeyTacAllOfProviderConfigurationComplexity getComplexity() {
        return this.complexity;
    }

    @JsonProperty(value="complexity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setComplexity(AuthenticatorKeyTacAllOfProviderConfigurationComplexity complexity) {
        this.complexity = complexity;
    }

    public AuthenticatorKeyTacAllOfProviderConfiguration multiUseAllowed(Boolean multiUseAllowed) {
        this.multiUseAllowed = multiUseAllowed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether a TAC can be used multiple times. If set to `true`, the TAC can be used multiple times until it expires.")
    @JsonProperty(value="multiUseAllowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMultiUseAllowed() {
        return this.multiUseAllowed;
    }

    @JsonProperty(value="multiUseAllowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultiUseAllowed(Boolean multiUseAllowed) {
        this.multiUseAllowed = multiUseAllowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorKeyTacAllOfProviderConfiguration authenticatorKeyTacAllOfProviderConfiguration = (AuthenticatorKeyTacAllOfProviderConfiguration)o;
        return Objects.equals(this.minTtl, authenticatorKeyTacAllOfProviderConfiguration.minTtl) && Objects.equals(this.maxTtl, authenticatorKeyTacAllOfProviderConfiguration.maxTtl) && Objects.equals(this.defaultTtl, authenticatorKeyTacAllOfProviderConfiguration.defaultTtl) && Objects.equals(this.length, authenticatorKeyTacAllOfProviderConfiguration.length) && Objects.equals(this.complexity, authenticatorKeyTacAllOfProviderConfiguration.complexity) && Objects.equals(this.multiUseAllowed, authenticatorKeyTacAllOfProviderConfiguration.multiUseAllowed);
    }

    public int hashCode() {
        return Objects.hash(this.minTtl, this.maxTtl, this.defaultTtl, this.length, this.complexity, this.multiUseAllowed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorKeyTacAllOfProviderConfiguration {\n");
        sb.append("    minTtl: ").append(this.toIndentedString(this.minTtl)).append("\n");
        sb.append("    maxTtl: ").append(this.toIndentedString(this.maxTtl)).append("\n");
        sb.append("    defaultTtl: ").append(this.toIndentedString(this.defaultTtl)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    complexity: ").append(this.toIndentedString(this.complexity)).append("\n");
        sb.append("    multiUseAllowed: ").append(this.toIndentedString(this.multiUseAllowed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

