/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Embedded resources related to the app using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. If the `expand=user/{userId}` query parameter is specified, then the assigned [Application User](/openapi/okta-management/management/tag/ApplicationUsers/) is embedded.")
@JsonPropertyOrder(value={"user"})
@JsonTypeName(value="Application__embedded")
public class ApplicationEmbedded
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_USER = "user";
    private Map<String, Object> user = null;

    public ApplicationEmbedded user(Map<String, Object> user) {
        this.user = user;
        return this;
    }

    public ApplicationEmbedded putuserItem(String key, Object userItem) {
        if (this.user == null) {
            this.user = new HashMap<String, Object>();
        }
        this.user.put(key, userItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The specified [Application User](/openapi/okta-management/management/tag/ApplicationUsers/) assigned to the app")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(Map<String, Object> user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationEmbedded applicationEmbedded = (ApplicationEmbedded)o;
        return Objects.equals(this.user, applicationEmbedded.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationEmbedded {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

