/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AppUserCredentials;
import com.okta.sdk.resource.model.AppUserStatus;
import com.okta.sdk.resource.model.AppUserSyncState;
import com.okta.sdk.resource.model.LinksAppAndUser;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"created", "credentials", "externalId", "id", "lastSync", "lastUpdated", "passwordChanged", "profile", "scope", "status", "statusChanged", "syncState", "_embedded", "_links"})
public class AppUserAssignRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private AppUserCredentials credentials;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_SYNC = "lastSync";
    private OffsetDateTime lastSync;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_PASSWORD_CHANGED = "passwordChanged";
    private JsonNullable<OffsetDateTime> passwordChanged = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private ScopeEnum scope;
    public static final String JSON_PROPERTY_STATUS = "status";
    private AppUserStatus status;
    public static final String JSON_PROPERTY_STATUS_CHANGED = "statusChanged";
    private OffsetDateTime statusChanged;
    public static final String JSON_PROPERTY_SYNC_STATE = "syncState";
    private AppUserSyncState syncState;
    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksAppAndUser links;

    @Nullable
    @ApiModelProperty(example="2017-03-28T01:11:10Z", value="Timestamp when the object was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public AppUserAssignRequest credentials(AppUserCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppUserCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(AppUserCredentials credentials) {
        this.credentials = credentials;
    }

    @Nullable
    @ApiModelProperty(example="70c14cc17d3745e8a9f98d599a68329c", value="The ID of the user in the target app that's linked to the Okta application user object. This value is the native app-specific identifier or primary key for the user in the target app.  The `externalId` is set during import when the user is confirmed (reconciled) or during provisioning when the user is created in the target app. This value isn't populated for SSO app assignments (for example, SAML or SWA) because it isn't synchronized with a target app.")
    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalId() {
        return this.externalId;
    }

    public AppUserAssignRequest id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00u11z6WHMYCGPCHCRFK", value="Unique identifier for the Okta user")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    @ApiModelProperty(example="2014-06-24T15:27:59Z", value="Timestamp of the last synchronization operation. This value is only updated for apps with the `IMPORT_PROFILE_UPDATES` or `PUSH PROFILE_UPDATES` feature.")
    @JsonProperty(value="lastSync")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastSync() {
        return this.lastSync;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the object was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    @Nullable
    @ApiModelProperty(example="2014-06-24T15:27:59Z", value="Timestamp when the application user password was last changed")
    @JsonIgnore
    public OffsetDateTime getPasswordChanged() {
        if (this.passwordChanged == null) {
            this.passwordChanged = JsonNullable.undefined();
        }
        return (OffsetDateTime)this.passwordChanged.orElse(null);
    }

    @JsonProperty(value="passwordChanged")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getPasswordChanged_JsonNullable() {
        return this.passwordChanged;
    }

    @JsonProperty(value="passwordChanged")
    private void setPasswordChanged_JsonNullable(JsonNullable<OffsetDateTime> passwordChanged) {
        this.passwordChanged = passwordChanged;
    }

    public AppUserAssignRequest profile(Map<String, Object> profile) {
        this.profile = profile;
        return this;
    }

    public AppUserAssignRequest putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<String, Object>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the default and custom profile properties for a user. Properties that are visible in the Admin Console for an app assignment can also be assigned through the API. Some properties are reference properties that are imported from the target app and can't be configured. See [profile](/openapi/okta-management/management/tag/User/#tag/User/operation/getUser!c=200&path=profile&t=response). ")
    @JsonProperty(value="profile")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public AppUserAssignRequest scope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USER", value="Indicates if the assignment is direct (`USER`) or by group membership (`GROUP`).")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScopeEnum getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public AppUserAssignRequest status(AppUserStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppUserStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(AppUserStatus status) {
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(example="2014-06-24T15:28:14Z", value="Timestamp when the application user status was last changed")
    @JsonProperty(value="statusChanged")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStatusChanged() {
        return this.statusChanged;
    }

    public AppUserAssignRequest syncState(AppUserSyncState syncState) {
        this.syncState = syncState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="syncState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppUserSyncState getSyncState() {
        return this.syncState;
    }

    @JsonProperty(value="syncState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncState(AppUserSyncState syncState) {
        this.syncState = syncState;
    }

    @Nullable
    @ApiModelProperty(value="Embedded resources related to the application user using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getEmbedded() {
        return this.embedded;
    }

    public AppUserAssignRequest links(LinksAppAndUser links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksAppAndUser getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksAppAndUser links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppUserAssignRequest appUserAssignRequest = (AppUserAssignRequest)o;
        return Objects.equals(this.created, appUserAssignRequest.created) && Objects.equals(this.credentials, appUserAssignRequest.credentials) && Objects.equals(this.externalId, appUserAssignRequest.externalId) && Objects.equals(this.id, appUserAssignRequest.id) && Objects.equals(this.lastSync, appUserAssignRequest.lastSync) && Objects.equals(this.lastUpdated, appUserAssignRequest.lastUpdated) && AppUserAssignRequest.equalsNullable(this.passwordChanged, appUserAssignRequest.passwordChanged) && Objects.equals(this.profile, appUserAssignRequest.profile) && Objects.equals((Object)this.scope, (Object)appUserAssignRequest.scope) && Objects.equals((Object)this.status, (Object)appUserAssignRequest.status) && Objects.equals(this.statusChanged, appUserAssignRequest.statusChanged) && Objects.equals((Object)this.syncState, (Object)appUserAssignRequest.syncState) && Objects.equals(this.embedded, appUserAssignRequest.embedded) && Objects.equals(this.links, appUserAssignRequest.links);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.credentials, this.externalId, this.id, this.lastSync, this.lastUpdated, AppUserAssignRequest.hashCodeNullable(this.passwordChanged), this.profile, this.scope, this.status, this.statusChanged, this.syncState, this.embedded, this.links});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppUserAssignRequest {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastSync: ").append(this.toIndentedString(this.lastSync)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    passwordChanged: ").append(this.toIndentedString(this.passwordChanged)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusChanged: ").append(this.toIndentedString(this.statusChanged)).append("\n");
        sb.append("    syncState: ").append(this.toIndentedString((Object)this.syncState)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScopeEnum {
        USER(String.valueOf("USER")),
        GROUP(String.valueOf("GROUP")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ScopeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScopeEnum fromValue(String value) {
            for (ScopeEnum b : ScopeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

