/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ServiceAccountStatus;
import com.okta.sdk.resource.model.ServiceAccountStatusDetail;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"containerGlobalName", "containerInstanceName", "containerOrn", "created", "description", "id", "lastUpdated", "name", "ownerGroupIds", "ownerUserIds", "password", "status", "statusDetail", "username"})
public class AppServiceAccount
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CONTAINER_GLOBAL_NAME = "containerGlobalName";
    private String containerGlobalName;
    public static final String JSON_PROPERTY_CONTAINER_INSTANCE_NAME = "containerInstanceName";
    private String containerInstanceName;
    public static final String JSON_PROPERTY_CONTAINER_ORN = "containerOrn";
    private String containerOrn;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER_GROUP_IDS = "ownerGroupIds";
    private List<String> ownerGroupIds = null;
    public static final String JSON_PROPERTY_OWNER_USER_IDS = "ownerUserIds";
    private List<String> ownerUserIds = null;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ServiceAccountStatus status;
    public static final String JSON_PROPERTY_STATUS_DETAIL = "statusDetail";
    private ServiceAccountStatusDetail statusDetail;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    @Nullable
    @ApiModelProperty(example="salesforce", value="The key name of the app in the Okta Integration Network (OIN)")
    @JsonProperty(value="containerGlobalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContainerGlobalName() {
        return this.containerGlobalName;
    }

    @Nullable
    @ApiModelProperty(example="salesforce Prod 5", value="The app instance label")
    @JsonProperty(value="containerInstanceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContainerInstanceName() {
        return this.containerInstanceName;
    }

    public AppServiceAccount containerOrn(String containerOrn) {
        this.containerOrn = containerOrn;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="orn:okta:idp:00o1n8sbwArJ7OQRw406:apps:salesforce:0oa1gjh63g214q0Hq0g4", required=true, value="The [ORN](/openapi/okta-management/guides/roles/#okta-resource-name-orn) of the relevant resource.  Use the specific app ORN format (`orn:{partition}:idp:{yourOrgId}:apps:{appType}:{appId}`) to identify an Okta app instance in your org.")
    @JsonProperty(value="containerOrn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContainerOrn() {
        return this.containerOrn;
    }

    @JsonProperty(value="containerOrn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContainerOrn(String containerOrn) {
        this.containerOrn = containerOrn;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the app service account was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public AppServiceAccount description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is for accessing salesforce Prod-5", value="The description of the app service account")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(example="a747a818-a4c4-4446-8a87-704216495a08", value="The UUID of the app service account")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the app service account was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public AppServiceAccount name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="salesforce Prod-5 account", required=true, value="The user-defined name for the app service account")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public AppServiceAccount ownerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
        return this;
    }

    public AppServiceAccount addownerGroupIdsItem(String ownerGroupIdsItem) {
        if (this.ownerGroupIds == null) {
            this.ownerGroupIds = new ArrayList<String>();
        }
        this.ownerGroupIds.add(ownerGroupIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"00g57qp78yZT2XBA40g7\"]", value="A list of IDs of the Okta groups who own the app service account")
    @JsonProperty(value="ownerGroupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOwnerGroupIds() {
        return this.ownerGroupIds;
    }

    @JsonProperty(value="ownerGroupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
    }

    public AppServiceAccount ownerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
        return this;
    }

    public AppServiceAccount addownerUserIdsItem(String ownerUserIdsItem) {
        if (this.ownerUserIds == null) {
            this.ownerUserIds = new ArrayList<String>();
        }
        this.ownerUserIds.add(ownerUserIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"00u11s48P9zGW8yqm0g5\"]", value="A list of IDs of the Okta users who own the app service account")
    @JsonProperty(value="ownerUserIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOwnerUserIds() {
        return this.ownerUserIds;
    }

    @JsonProperty(value="ownerUserIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
    }

    public AppServiceAccount password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The app service account password. Required for apps that don't have provisioning enabled or don't support password synchronization.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public AppServiceAccount status(ServiceAccountStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceAccountStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ServiceAccountStatus status) {
        this.status = status;
    }

    public AppServiceAccount statusDetail(ServiceAccountStatusDetail statusDetail) {
        this.statusDetail = statusDetail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="statusDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceAccountStatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    @JsonProperty(value="statusDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusDetail(ServiceAccountStatusDetail statusDetail) {
        this.statusDetail = statusDetail;
    }

    public AppServiceAccount username(String username) {
        this.username = username;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="testuser-salesforce-5@example.com", required=true, value="The username that serves as the direct link to your managed app account. Ensure that this value precisely matches the identifier of the target app account.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppServiceAccount appServiceAccount = (AppServiceAccount)o;
        return Objects.equals(this.containerGlobalName, appServiceAccount.containerGlobalName) && Objects.equals(this.containerInstanceName, appServiceAccount.containerInstanceName) && Objects.equals(this.containerOrn, appServiceAccount.containerOrn) && Objects.equals(this.created, appServiceAccount.created) && Objects.equals(this.description, appServiceAccount.description) && Objects.equals(this.id, appServiceAccount.id) && Objects.equals(this.lastUpdated, appServiceAccount.lastUpdated) && Objects.equals(this.name, appServiceAccount.name) && Objects.equals(this.ownerGroupIds, appServiceAccount.ownerGroupIds) && Objects.equals(this.ownerUserIds, appServiceAccount.ownerUserIds) && Objects.equals(this.password, appServiceAccount.password) && Objects.equals((Object)this.status, (Object)appServiceAccount.status) && Objects.equals((Object)this.statusDetail, (Object)appServiceAccount.statusDetail) && Objects.equals(this.username, appServiceAccount.username);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerGlobalName, this.containerInstanceName, this.containerOrn, this.created, this.description, this.id, this.lastUpdated, this.name, this.ownerGroupIds, this.ownerUserIds, this.password, this.status, this.statusDetail, this.username});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppServiceAccount {\n");
        sb.append("    containerGlobalName: ").append(this.toIndentedString(this.containerGlobalName)).append("\n");
        sb.append("    containerInstanceName: ").append(this.toIndentedString(this.containerInstanceName)).append("\n");
        sb.append("    containerOrn: ").append(this.toIndentedString(this.containerOrn)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerGroupIds: ").append(this.toIndentedString(this.ownerGroupIds)).append("\n");
        sb.append("    ownerUserIds: ").append(this.toIndentedString(this.ownerUserIds)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusDetail: ").append(this.toIndentedString((Object)this.statusDetail)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

