/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.Agent;
import com.okta.sdk.resource.model.AgentType;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.OperationalStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An agent pool is a collection of agents that serve a common purpose. An agent pool has a unique ID within an org, and contains a collection of agents disjoint to every other agent pool, meaning that no two agent pools share an agent.")
@JsonPropertyOrder(value={"agents", "disruptedAgents", "id", "inactiveAgents", "name", "operationalStatus", "type", "_links"})
public class AgentPool
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AGENTS = "agents";
    private List<Agent> agents = null;
    public static final String JSON_PROPERTY_DISRUPTED_AGENTS = "disruptedAgents";
    private Integer disruptedAgents;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INACTIVE_AGENTS = "inactiveAgents";
    private Integer inactiveAgents;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPERATIONAL_STATUS = "operationalStatus";
    private OperationalStatus operationalStatus;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AgentType type;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public AgentPool agents(List<Agent> agents) {
        this.agents = agents;
        return this;
    }

    public AgentPool addagentsItem(Agent agentsItem) {
        if (this.agents == null) {
            this.agents = new ArrayList<Agent>();
        }
        this.agents.add(agentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="agents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Agent> getAgents() {
        return this.agents;
    }

    @JsonProperty(value="agents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAgents(List<Agent> agents) {
        this.agents = agents;
    }

    public AgentPool disruptedAgents(Integer disruptedAgents) {
        this.disruptedAgents = disruptedAgents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of agents in the pool that are in a disrupted state")
    @JsonProperty(value="disruptedAgents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDisruptedAgents() {
        return this.disruptedAgents;
    }

    @JsonProperty(value="disruptedAgents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisruptedAgents(Integer disruptedAgents) {
        this.disruptedAgents = disruptedAgents;
    }

    @Nullable
    @ApiModelProperty(value="Agent pool ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public AgentPool inactiveAgents(Integer inactiveAgents) {
        this.inactiveAgents = inactiveAgents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of agents in the pool that are in an inactive state")
    @JsonProperty(value="inactiveAgents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getInactiveAgents() {
        return this.inactiveAgents;
    }

    @JsonProperty(value="inactiveAgents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInactiveAgents(Integer inactiveAgents) {
        this.inactiveAgents = inactiveAgents;
    }

    public AgentPool name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Agent pool name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AgentPool operationalStatus(OperationalStatus operationalStatus) {
        this.operationalStatus = operationalStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="operationalStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OperationalStatus getOperationalStatus() {
        return this.operationalStatus;
    }

    @JsonProperty(value="operationalStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperationalStatus(OperationalStatus operationalStatus) {
        this.operationalStatus = operationalStatus;
    }

    public AgentPool type(AgentType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AgentType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(AgentType type) {
        this.type = type;
    }

    public AgentPool links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentPool agentPool = (AgentPool)o;
        return Objects.equals(this.agents, agentPool.agents) && Objects.equals(this.disruptedAgents, agentPool.disruptedAgents) && Objects.equals(this.id, agentPool.id) && Objects.equals(this.inactiveAgents, agentPool.inactiveAgents) && Objects.equals(this.name, agentPool.name) && Objects.equals((Object)this.operationalStatus, (Object)agentPool.operationalStatus) && Objects.equals((Object)this.type, (Object)agentPool.type) && Objects.equals(this.links, agentPool.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.agents, this.disruptedAgents, this.id, this.inactiveAgents, this.name, this.operationalStatus, this.type, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentPool {\n");
        sb.append("    agents: ").append(this.toIndentedString(this.agents)).append("\n");
        sb.append("    disruptedAgents: ").append(this.toIndentedString(this.disruptedAgents)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    inactiveAgents: ").append(this.toIndentedString(this.inactiveAgents)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operationalStatus: ").append(this.toIndentedString((Object)this.operationalStatus)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

