/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"fileName", "keyId", "teamId", "tokenSigningKey"})
public class APNSConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName;
    public static final String JSON_PROPERTY_KEY_ID = "keyId";
    private String keyId;
    public static final String JSON_PROPERTY_TEAM_ID = "teamId";
    private String teamId;
    public static final String JSON_PROPERTY_TOKEN_SIGNING_KEY = "tokenSigningKey";
    private String tokenSigningKey;

    public APNSConfiguration fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="(Optional) File name for Admin Console display")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public APNSConfiguration keyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="10-character Key ID obtained from the Apple developer account")
    @JsonProperty(value="keyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKeyId() {
        return this.keyId;
    }

    @JsonProperty(value="keyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public APNSConfiguration teamId(String teamId) {
        this.teamId = teamId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="10-character Team ID used to develop the iOS app")
    @JsonProperty(value="teamId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeamId() {
        return this.teamId;
    }

    @JsonProperty(value="teamId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public APNSConfiguration tokenSigningKey(String tokenSigningKey) {
        this.tokenSigningKey = tokenSigningKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APNs private authentication token signing key")
    @JsonProperty(value="tokenSigningKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenSigningKey() {
        return this.tokenSigningKey;
    }

    @JsonProperty(value="tokenSigningKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenSigningKey(String tokenSigningKey) {
        this.tokenSigningKey = tokenSigningKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APNSConfiguration apNSConfiguration = (APNSConfiguration)o;
        return Objects.equals(this.fileName, apNSConfiguration.fileName) && Objects.equals(this.keyId, apNSConfiguration.keyId) && Objects.equals(this.teamId, apNSConfiguration.teamId) && Objects.equals(this.tokenSigningKey, apNSConfiguration.tokenSigningKey);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.keyId, this.teamId, this.tokenSigningKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APNSConfiguration {\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    keyId: ").append(this.toIndentedString(this.keyId)).append("\n");
        sb.append("    teamId: ").append(this.toIndentedString(this.teamId)).append("\n");
        sb.append("    tokenSigningKey: ").append(this.toIndentedString(this.tokenSigningKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

