/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AIAgentResource;
import com.okta.sdk.resource.model.ErrorDetails;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"completed", "created", "errorDetails", "id", "resource", "started", "status", "type"})
public class AIAgentOperationResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_COMPLETED = "completed";
    private OffsetDateTime completed;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ERROR_DETAILS = "errorDetails";
    private ErrorDetails errorDetails;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RESOURCE = "resource";
    private AIAgentResource resource;
    public static final String JSON_PROPERTY_STARTED = "started";
    private OffsetDateTime started;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public AIAgentOperationResponse completed(OffsetDateTime completed) {
        this.completed = completed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp of when the AI agent operation completed")
    @JsonProperty(value="completed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCompleted() {
        return this.completed;
    }

    @JsonProperty(value="completed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompleted(OffsetDateTime completed) {
        this.completed = completed;
    }

    public AIAgentOperationResponse created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Timestamp of when the AI agent operation was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public AIAgentOperationResponse errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    @JsonProperty(value="errorDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public AIAgentOperationResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ID of the AI agent operation")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public AIAgentOperationResponse resource(AIAgentResource resource) {
        this.resource = resource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="resource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AIAgentResource getResource() {
        return this.resource;
    }

    @JsonProperty(value="resource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResource(AIAgentResource resource) {
        this.resource = resource;
    }

    public AIAgentOperationResponse started(OffsetDateTime started) {
        this.started = started;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp of when the AI agent operation started")
    @JsonProperty(value="started")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStarted() {
        return this.started;
    }

    @JsonProperty(value="started")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStarted(OffsetDateTime started) {
        this.started = started;
    }

    public AIAgentOperationResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The status of the AI agent operation")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AIAgentOperationResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The AI agent operation type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AIAgentOperationResponse aiAgentOperationResponse = (AIAgentOperationResponse)o;
        return Objects.equals(this.completed, aiAgentOperationResponse.completed) && Objects.equals(this.created, aiAgentOperationResponse.created) && Objects.equals(this.errorDetails, aiAgentOperationResponse.errorDetails) && Objects.equals(this.id, aiAgentOperationResponse.id) && Objects.equals(this.resource, aiAgentOperationResponse.resource) && Objects.equals(this.started, aiAgentOperationResponse.started) && Objects.equals((Object)this.status, (Object)aiAgentOperationResponse.status) && Objects.equals((Object)this.type, (Object)aiAgentOperationResponse.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.completed, this.created, this.errorDetails, this.id, this.resource, this.started, this.status, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AIAgentOperationResponse {\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        COMPLETED(String.valueOf("COMPLETED")),
        SCHEDULED(String.valueOf("SCHEDULED")),
        IN_PROGRESS(String.valueOf("IN_PROGRESS")),
        FAILED(String.valueOf("FAILED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum TypeEnum {
        AI_AGENT_REGISTER(String.valueOf("ai-agent:Register")),
        AI_AGENT_REPLACE(String.valueOf("ai-agent:Replace")),
        AI_AGENT_DELETE(String.valueOf("ai-agent:Delete")),
        AI_AGENT_ACTIVATE(String.valueOf("ai-agent:Activate")),
        AI_AGENT_DEACTIVATE(String.valueOf("ai-agent:Deactivate")),
        AI_AGENT_PATCH(String.valueOf("ai-agent:Patch")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

