/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.ResendUserFactor;
import com.okta.sdk.resource.model.UploadYubikeyOtpTokenSeedRequest;
import com.okta.sdk.resource.model.UserFactor;
import com.okta.sdk.resource.model.UserFactorActivateRequest;
import com.okta.sdk.resource.model.UserFactorActivateResponse;
import com.okta.sdk.resource.model.UserFactorPushTransaction;
import com.okta.sdk.resource.model.UserFactorSecurityQuestionProfile;
import com.okta.sdk.resource.model.UserFactorSupported;
import com.okta.sdk.resource.model.UserFactorVerifyRequest;
import com.okta.sdk.resource.model.UserFactorVerifyResponse;
import com.okta.sdk.resource.model.UserFactorYubikeyOtpToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class UserFactorApi {
    private ApiClient apiClient;

    public UserFactorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserFactorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserFactorActivateResponse activateFactor(String userId, String factorId, UserFactorActivateRequest body) throws ApiException {
        return this.activateFactor(userId, factorId, body, Collections.emptyMap());
    }

    public UserFactorActivateResponse activateFactor(String userId, String factorId, UserFactorActivateRequest body, Map<String, String> additionalHeaders) throws ApiException {
        UserFactorActivateRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling activateFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling activateFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactorActivateResponse> localVarReturnType = new TypeReference<UserFactorActivateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserFactor enrollFactor(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate, String acceptLanguage) throws ApiException {
        return this.enrollFactor(userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate, acceptLanguage, Collections.emptyMap());
    }

    public UserFactor enrollFactor(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate, String acceptLanguage, Map<String, String> additionalHeaders) throws ApiException {
        UserFactor localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling enrollFactor");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling enrollFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("updatePhone", updatePhone));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tokenLifetimeSeconds", tokenLifetimeSeconds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activate", activate));
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactor> localVarReturnType = new TypeReference<UserFactor>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserFactor getFactor(String userId, String factorId) throws ApiException {
        return this.getFactor(userId, factorId, Collections.emptyMap());
    }

    public UserFactor getFactor(String userId, String factorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling getFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactor> localVarReturnType = new TypeReference<UserFactor>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserFactorPushTransaction getFactorTransactionStatus(String userId, String factorId, String transactionId) throws ApiException {
        return this.getFactorTransactionStatus(userId, factorId, transactionId, Collections.emptyMap());
    }

    public UserFactorPushTransaction getFactorTransactionStatus(String userId, String factorId, String transactionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getFactorTransactionStatus");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling getFactorTransactionStatus");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling getFactorTransactionStatus");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString())).replaceAll("\\{transactionId\\}", this.apiClient.escapeString(transactionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactorPushTransaction> localVarReturnType = new TypeReference<UserFactorPushTransaction>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserFactorYubikeyOtpToken getYubikeyOtpTokenById(String tokenId) throws ApiException {
        return this.getYubikeyOtpTokenById(tokenId, Collections.emptyMap());
    }

    public UserFactorYubikeyOtpToken getYubikeyOtpTokenById(String tokenId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (tokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenId' when calling getYubikeyOtpTokenById");
        }
        String localVarPath = "/api/v1/org/factors/yubikey_token/tokens/{tokenId}".replaceAll("\\{tokenId\\}", this.apiClient.escapeString(tokenId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactorYubikeyOtpToken> localVarReturnType = new TypeReference<UserFactorYubikeyOtpToken>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<UserFactor> listFactors(String userId) throws ApiException {
        return this.listFactors(userId, Collections.emptyMap());
    }

    public List<UserFactor> listFactors(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listFactors");
        }
        String localVarPath = "/api/v1/users/{userId}/factors".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<UserFactor>> localVarReturnType = new TypeReference<List<UserFactor>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<UserFactor> listFactorsPaged(String userId) {
        return this.listFactorsPaged(userId, Collections.emptyMap());
    }

    public Iterable<UserFactor> listFactorsPaged(String userId, Map<String, String> additionalHeaders) {
        return new PagedIterable<UserFactor>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/users/{userId}/factors".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<UserFactor>> localVarReturnType = new TypeReference<List<UserFactor>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<UserFactor>> localVarReturnType = new TypeReference<List<UserFactor>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<UserFactorSupported> listSupportedFactors(String userId) throws ApiException {
        return this.listSupportedFactors(userId, Collections.emptyMap());
    }

    public List<UserFactorSupported> listSupportedFactors(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSupportedFactors");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/catalog".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<UserFactorSupported>> localVarReturnType = new TypeReference<List<UserFactorSupported>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<UserFactorSupported> listSupportedFactorsPaged(String userId) {
        return this.listSupportedFactorsPaged(userId, Collections.emptyMap());
    }

    public Iterable<UserFactorSupported> listSupportedFactorsPaged(String userId, Map<String, String> additionalHeaders) {
        return new PagedIterable<UserFactorSupported>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/users/{userId}/factors/catalog".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<UserFactorSupported>> localVarReturnType = new TypeReference<List<UserFactorSupported>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<UserFactorSupported>> localVarReturnType = new TypeReference<List<UserFactorSupported>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<UserFactorSecurityQuestionProfile> listSupportedSecurityQuestions(String userId) throws ApiException {
        return this.listSupportedSecurityQuestions(userId, Collections.emptyMap());
    }

    public List<UserFactorSecurityQuestionProfile> listSupportedSecurityQuestions(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSupportedSecurityQuestions");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/questions".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        TypeReference<List<UserFactorSecurityQuestionProfile>> localVarReturnType = new TypeReference<List<UserFactorSecurityQuestionProfile>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<UserFactorSecurityQuestionProfile> listSupportedSecurityQuestionsPaged(String userId) {
        return this.listSupportedSecurityQuestionsPaged(userId, Collections.emptyMap());
    }

    public Iterable<UserFactorSecurityQuestionProfile> listSupportedSecurityQuestionsPaged(String userId, Map<String, String> additionalHeaders) {
        return new PagedIterable<UserFactorSecurityQuestionProfile>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/users/{userId}/factors/questions".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken"};
                    TypeReference<List<UserFactorSecurityQuestionProfile>> localVarReturnType = new TypeReference<List<UserFactorSecurityQuestionProfile>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken"};
                TypeReference<List<UserFactorSecurityQuestionProfile>> localVarReturnType = new TypeReference<List<UserFactorSecurityQuestionProfile>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<UserFactorYubikeyOtpToken> listYubikeyOtpTokens(String after, String expand, String filter, Boolean forDownload, Integer limit, String sortBy, String sortOrder) throws ApiException {
        return this.listYubikeyOtpTokens(after, expand, filter, forDownload, limit, sortBy, sortOrder, Collections.emptyMap());
    }

    public List<UserFactorYubikeyOtpToken> listYubikeyOtpTokens(String after, String expand, String filter, Boolean forDownload, Integer limit, String sortBy, String sortOrder, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/org/factors/yubikey_token/tokens";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("forDownload", forDownload));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<UserFactorYubikeyOtpToken>> localVarReturnType = new TypeReference<List<UserFactorYubikeyOtpToken>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<UserFactorYubikeyOtpToken> listYubikeyOtpTokensPaged(String after, String expand, String filter, Boolean forDownload, Integer limit, String sortBy, String sortOrder) {
        return this.listYubikeyOtpTokensPaged(after, expand, filter, forDownload, limit, sortBy, sortOrder, Collections.emptyMap());
    }

    public Iterable<UserFactorYubikeyOtpToken> listYubikeyOtpTokensPaged(String after, String expand, String filter, Boolean forDownload, Integer limit, String sortBy, String sortOrder, Map<String, String> additionalHeaders) {
        return new PagedIterable<UserFactorYubikeyOtpToken>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/org/factors/yubikey_token/tokens";
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("forDownload", forDownload));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<UserFactorYubikeyOtpToken>> localVarReturnType = new TypeReference<List<UserFactorYubikeyOtpToken>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<UserFactorYubikeyOtpToken>> localVarReturnType = new TypeReference<List<UserFactorYubikeyOtpToken>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public ResendUserFactor resendEnrollFactor(String userId, String factorId, ResendUserFactor resendUserFactor, String templateId) throws ApiException {
        return this.resendEnrollFactor(userId, factorId, resendUserFactor, templateId, Collections.emptyMap());
    }

    public ResendUserFactor resendEnrollFactor(String userId, String factorId, ResendUserFactor resendUserFactor, String templateId, Map<String, String> additionalHeaders) throws ApiException {
        ResendUserFactor localVarPostBody = resendUserFactor;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling resendEnrollFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling resendEnrollFactor");
        }
        if (resendUserFactor == null) {
            throw new ApiException(400, "Missing the required parameter 'resendUserFactor' when calling resendEnrollFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/resend".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResendUserFactor> localVarReturnType = new TypeReference<ResendUserFactor>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unenrollFactor(String userId, String factorId, Boolean removeRecoveryEnrollment) throws ApiException {
        this.unenrollFactor(userId, factorId, removeRecoveryEnrollment, Collections.emptyMap());
    }

    public void unenrollFactor(String userId, String factorId, Boolean removeRecoveryEnrollment, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unenrollFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling unenrollFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("removeRecoveryEnrollment", removeRecoveryEnrollment));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public UserFactorYubikeyOtpToken uploadYubikeyOtpTokenSeed(UploadYubikeyOtpTokenSeedRequest uploadYubikeyOtpTokenSeedRequest, String after, String expand, String filter, Boolean forDownload, Integer limit, String sortBy, String sortOrder) throws ApiException {
        return this.uploadYubikeyOtpTokenSeed(uploadYubikeyOtpTokenSeedRequest, after, expand, filter, forDownload, limit, sortBy, sortOrder, Collections.emptyMap());
    }

    public UserFactorYubikeyOtpToken uploadYubikeyOtpTokenSeed(UploadYubikeyOtpTokenSeedRequest uploadYubikeyOtpTokenSeedRequest, String after, String expand, String filter, Boolean forDownload, Integer limit, String sortBy, String sortOrder, Map<String, String> additionalHeaders) throws ApiException {
        UploadYubikeyOtpTokenSeedRequest localVarPostBody = uploadYubikeyOtpTokenSeedRequest;
        if (uploadYubikeyOtpTokenSeedRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadYubikeyOtpTokenSeedRequest' when calling uploadYubikeyOtpTokenSeed");
        }
        String localVarPath = "/api/v1/org/factors/yubikey_token/tokens";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("forDownload", forDownload));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactorYubikeyOtpToken> localVarReturnType = new TypeReference<UserFactorYubikeyOtpToken>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserFactorVerifyResponse verifyFactor(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, UserFactorVerifyRequest body) throws ApiException {
        return this.verifyFactor(userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body, Collections.emptyMap());
    }

    public UserFactorVerifyResponse verifyFactor(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, UserFactorVerifyRequest body, Map<String, String> additionalHeaders) throws ApiException {
        UserFactorVerifyRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling verifyFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling verifyFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/verify".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tokenLifetimeSeconds", tokenLifetimeSeconds));
        if (xForwardedFor != null) {
            localVarHeaderParams.put("X-Forwarded-For", this.apiClient.parameterToString(xForwardedFor));
        }
        if (userAgent != null) {
            localVarHeaderParams.put("User-Agent", this.apiClient.parameterToString(userAgent));
        }
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactorVerifyResponse> localVarReturnType = new TypeReference<UserFactorVerifyResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

