/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.CreateUISchema;
import com.okta.sdk.resource.model.UISchemasResponseObject;
import com.okta.sdk.resource.model.UpdateUISchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class UiSchemaApi {
    private ApiClient apiClient;

    public UiSchemaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UiSchemaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UISchemasResponseObject createUISchema(CreateUISchema uischemabody) throws ApiException {
        return this.createUISchema(uischemabody, Collections.emptyMap());
    }

    public UISchemasResponseObject createUISchema(CreateUISchema uischemabody, Map<String, String> additionalHeaders) throws ApiException {
        CreateUISchema localVarPostBody = uischemabody;
        if (uischemabody == null) {
            throw new ApiException(400, "Missing the required parameter 'uischemabody' when calling createUISchema");
        }
        String localVarPath = "/api/v1/meta/uischemas";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UISchemasResponseObject> localVarReturnType = new TypeReference<UISchemasResponseObject>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteUISchemas(String id) throws ApiException {
        this.deleteUISchemas(id, Collections.emptyMap());
    }

    public void deleteUISchemas(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteUISchemas");
        }
        String localVarPath = "/api/v1/meta/uischemas/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public UISchemasResponseObject getUISchema(String id) throws ApiException {
        return this.getUISchema(id, Collections.emptyMap());
    }

    public UISchemasResponseObject getUISchema(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getUISchema");
        }
        String localVarPath = "/api/v1/meta/uischemas/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UISchemasResponseObject> localVarReturnType = new TypeReference<UISchemasResponseObject>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<UISchemasResponseObject> listUISchemas() throws ApiException {
        return this.listUISchemas(Collections.emptyMap());
    }

    public List<UISchemasResponseObject> listUISchemas(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/meta/uischemas";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<UISchemasResponseObject>> localVarReturnType = new TypeReference<List<UISchemasResponseObject>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<UISchemasResponseObject> listUISchemasPaged() {
        return this.listUISchemasPaged(Collections.emptyMap());
    }

    public Iterable<UISchemasResponseObject> listUISchemasPaged(Map<String, String> additionalHeaders) {
        return new PagedIterable<UISchemasResponseObject>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/meta/uischemas";
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<UISchemasResponseObject>> localVarReturnType = new TypeReference<List<UISchemasResponseObject>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<UISchemasResponseObject>> localVarReturnType = new TypeReference<List<UISchemasResponseObject>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public UISchemasResponseObject replaceUISchemas(String id, UpdateUISchema updateUISchemaBody) throws ApiException {
        return this.replaceUISchemas(id, updateUISchemaBody, Collections.emptyMap());
    }

    public UISchemasResponseObject replaceUISchemas(String id, UpdateUISchema updateUISchemaBody, Map<String, String> additionalHeaders) throws ApiException {
        UpdateUISchema localVarPostBody = updateUISchemaBody;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling replaceUISchemas");
        }
        if (updateUISchemaBody == null) {
            throw new ApiException(400, "Missing the required parameter 'updateUISchemaBody' when calling replaceUISchemas");
        }
        String localVarPath = "/api/v1/meta/uischemas/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UISchemasResponseObject> localVarReturnType = new TypeReference<UISchemasResponseObject>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

