/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.TrustedOrigin;
import com.okta.sdk.resource.model.TrustedOriginWrite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class TrustedOriginApi {
    private ApiClient apiClient;

    public TrustedOriginApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TrustedOriginApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TrustedOrigin activateTrustedOrigin(String trustedOriginId) throws ApiException {
        return this.activateTrustedOrigin(trustedOriginId, Collections.emptyMap());
    }

    public TrustedOrigin activateTrustedOrigin(String trustedOriginId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new ApiException(400, "Missing the required parameter 'trustedOriginId' when calling activateTrustedOrigin");
        }
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}/lifecycle/activate".replaceAll("\\{trustedOriginId\\}", this.apiClient.escapeString(trustedOriginId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TrustedOrigin createTrustedOrigin(TrustedOriginWrite trustedOrigin) throws ApiException {
        return this.createTrustedOrigin(trustedOrigin, Collections.emptyMap());
    }

    public TrustedOrigin createTrustedOrigin(TrustedOriginWrite trustedOrigin, Map<String, String> additionalHeaders) throws ApiException {
        TrustedOriginWrite localVarPostBody = trustedOrigin;
        if (trustedOrigin == null) {
            throw new ApiException(400, "Missing the required parameter 'trustedOrigin' when calling createTrustedOrigin");
        }
        String localVarPath = "/api/v1/trustedOrigins";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TrustedOrigin deactivateTrustedOrigin(String trustedOriginId) throws ApiException {
        return this.deactivateTrustedOrigin(trustedOriginId, Collections.emptyMap());
    }

    public TrustedOrigin deactivateTrustedOrigin(String trustedOriginId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new ApiException(400, "Missing the required parameter 'trustedOriginId' when calling deactivateTrustedOrigin");
        }
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}/lifecycle/deactivate".replaceAll("\\{trustedOriginId\\}", this.apiClient.escapeString(trustedOriginId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteTrustedOrigin(String trustedOriginId) throws ApiException {
        this.deleteTrustedOrigin(trustedOriginId, Collections.emptyMap());
    }

    public void deleteTrustedOrigin(String trustedOriginId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new ApiException(400, "Missing the required parameter 'trustedOriginId' when calling deleteTrustedOrigin");
        }
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}".replaceAll("\\{trustedOriginId\\}", this.apiClient.escapeString(trustedOriginId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public TrustedOrigin getTrustedOrigin(String trustedOriginId) throws ApiException {
        return this.getTrustedOrigin(trustedOriginId, Collections.emptyMap());
    }

    public TrustedOrigin getTrustedOrigin(String trustedOriginId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new ApiException(400, "Missing the required parameter 'trustedOriginId' when calling getTrustedOrigin");
        }
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}".replaceAll("\\{trustedOriginId\\}", this.apiClient.escapeString(trustedOriginId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TrustedOrigin> listTrustedOrigins(String q, String filter, String after, Integer limit) throws ApiException {
        return this.listTrustedOrigins(q, filter, after, limit, Collections.emptyMap());
    }

    public List<TrustedOrigin> listTrustedOrigins(String q, String filter, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/trustedOrigins";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<TrustedOrigin>> localVarReturnType = new TypeReference<List<TrustedOrigin>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<TrustedOrigin> listTrustedOriginsPaged(String q, String filter, String after, Integer limit) {
        return this.listTrustedOriginsPaged(q, filter, after, limit, Collections.emptyMap());
    }

    public Iterable<TrustedOrigin> listTrustedOriginsPaged(String q, String filter, String after, Integer limit, Map<String, String> additionalHeaders) {
        return new PagedIterable<TrustedOrigin>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/trustedOrigins";
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<TrustedOrigin>> localVarReturnType = new TypeReference<List<TrustedOrigin>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<TrustedOrigin>> localVarReturnType = new TypeReference<List<TrustedOrigin>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public TrustedOrigin replaceTrustedOrigin(String trustedOriginId, TrustedOrigin trustedOrigin) throws ApiException {
        return this.replaceTrustedOrigin(trustedOriginId, trustedOrigin, Collections.emptyMap());
    }

    public TrustedOrigin replaceTrustedOrigin(String trustedOriginId, TrustedOrigin trustedOrigin, Map<String, String> additionalHeaders) throws ApiException {
        TrustedOrigin localVarPostBody = trustedOrigin;
        if (trustedOriginId == null) {
            throw new ApiException(400, "Missing the required parameter 'trustedOriginId' when calling replaceTrustedOrigin");
        }
        if (trustedOrigin == null) {
            throw new ApiException(400, "Missing the required parameter 'trustedOrigin' when calling replaceTrustedOrigin");
        }
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}".replaceAll("\\{trustedOriginId\\}", this.apiClient.escapeString(trustedOriginId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

