/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.CatalogApplication;
import com.okta.sdk.resource.model.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleBTargetClientApi {
    private ApiClient apiClient;

    public RoleBTargetClientApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleBTargetClientApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void assignAppTargetInstanceRoleForClient(String clientId, String roleAssignmentId, String appName, String appId) throws ApiException {
        this.assignAppTargetInstanceRoleForClient(clientId, roleAssignmentId, appName, appId, Collections.emptyMap());
    }

    public void assignAppTargetInstanceRoleForClient(String clientId, String roleAssignmentId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling assignAppTargetInstanceRoleForClient");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignAppTargetInstanceRoleForClient");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppTargetInstanceRoleForClient");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignAppTargetInstanceRoleForClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignAppTargetRoleToClient(String clientId, String roleAssignmentId, String appName) throws ApiException {
        this.assignAppTargetRoleToClient(clientId, roleAssignmentId, appName, Collections.emptyMap());
    }

    public void assignAppTargetRoleToClient(String clientId, String roleAssignmentId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling assignAppTargetRoleToClient");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignAppTargetRoleToClient");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppTargetRoleToClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignGroupTargetRoleForClient(String clientId, String roleAssignmentId, String groupId) throws ApiException {
        this.assignGroupTargetRoleForClient(clientId, roleAssignmentId, groupId, Collections.emptyMap());
    }

    public void assignGroupTargetRoleForClient(String clientId, String roleAssignmentId, String groupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling assignGroupTargetRoleForClient");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignGroupTargetRoleForClient");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignGroupTargetRoleForClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups/{groupId}".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<CatalogApplication> listAppTargetRoleToClient(String clientId, String roleAssignmentId, String after, Integer limit) throws ApiException {
        return this.listAppTargetRoleToClient(clientId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    public List<CatalogApplication> listAppTargetRoleToClient(String clientId, String roleAssignmentId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling listAppTargetRoleToClient");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling listAppTargetRoleToClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<CatalogApplication>> localVarReturnType = new TypeReference<List<CatalogApplication>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<CatalogApplication> listAppTargetRoleToClientPaged(String clientId, String roleAssignmentId, String after, Integer limit) {
        return this.listAppTargetRoleToClientPaged(clientId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    public Iterable<CatalogApplication> listAppTargetRoleToClientPaged(String clientId, String roleAssignmentId, String after, Integer limit, Map<String, String> additionalHeaders) {
        return new PagedIterable<CatalogApplication>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<CatalogApplication>> localVarReturnType = new TypeReference<List<CatalogApplication>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<CatalogApplication>> localVarReturnType = new TypeReference<List<CatalogApplication>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public List<Group> listGroupTargetRoleForClient(String clientId, String roleAssignmentId, String after, Integer limit) throws ApiException {
        return this.listGroupTargetRoleForClient(clientId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    public List<Group> listGroupTargetRoleForClient(String clientId, String roleAssignmentId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling listGroupTargetRoleForClient");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling listGroupTargetRoleForClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<Group> listGroupTargetRoleForClientPaged(String clientId, String roleAssignmentId, String after, Integer limit) {
        return this.listGroupTargetRoleForClientPaged(clientId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    public Iterable<Group> listGroupTargetRoleForClientPaged(String clientId, String roleAssignmentId, String after, Integer limit, Map<String, String> additionalHeaders) {
        return new PagedIterable<Group>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public void removeAppTargetInstanceRoleForClient(String clientId, String roleAssignmentId, String appName, String appId) throws ApiException {
        this.removeAppTargetInstanceRoleForClient(clientId, roleAssignmentId, appName, appId, Collections.emptyMap());
    }

    public void removeAppTargetInstanceRoleForClient(String clientId, String roleAssignmentId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling removeAppTargetInstanceRoleForClient");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling removeAppTargetInstanceRoleForClient");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling removeAppTargetInstanceRoleForClient");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling removeAppTargetInstanceRoleForClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void removeAppTargetRoleFromClient(String clientId, String roleAssignmentId, String appName) throws ApiException {
        this.removeAppTargetRoleFromClient(clientId, roleAssignmentId, appName, Collections.emptyMap());
    }

    public void removeAppTargetRoleFromClient(String clientId, String roleAssignmentId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling removeAppTargetRoleFromClient");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling removeAppTargetRoleFromClient");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling removeAppTargetRoleFromClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void removeGroupTargetRoleFromClient(String clientId, String roleAssignmentId, String groupId) throws ApiException {
        this.removeGroupTargetRoleFromClient(clientId, roleAssignmentId, groupId, Collections.emptyMap());
    }

    public void removeGroupTargetRoleFromClient(String clientId, String roleAssignmentId, String groupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling removeGroupTargetRoleFromClient");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling removeGroupTargetRoleFromClient");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling removeGroupTargetRoleFromClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups/{groupId}".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

