/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.BulkDeleteRequestBody;
import com.okta.sdk.resource.model.BulkGroupDeleteRequestBody;
import com.okta.sdk.resource.model.BulkGroupMembershipsDeleteRequestBody;
import com.okta.sdk.resource.model.BulkGroupMembershipsUpsertRequestBody;
import com.okta.sdk.resource.model.BulkGroupUpsertRequestBody;
import com.okta.sdk.resource.model.BulkUpsertRequestBody;
import com.okta.sdk.resource.model.IdentitySourceSession;
import com.okta.sdk.resource.model.UserRequestSchema;
import com.okta.sdk.resource.model.UserResponseSchema;
import com.okta.sdk.resource.model.UsersUpdateRequestSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class IdentitySourceApi {
    private ApiClient apiClient;

    public IdentitySourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentitySourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IdentitySourceSession createIdentitySourceSession(String identitySourceId) throws ApiException {
        return this.createIdentitySourceSession(identitySourceId, Collections.emptyMap());
    }

    public IdentitySourceSession createIdentitySourceSession(String identitySourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling createIdentitySourceSession");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentitySourceSession> localVarReturnType = new TypeReference<IdentitySourceSession>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void createIdentitySourceUser(String identitySourceId, UserRequestSchema userRequestSchema) throws ApiException {
        this.createIdentitySourceUser(identitySourceId, userRequestSchema, Collections.emptyMap());
    }

    public void createIdentitySourceUser(String identitySourceId, UserRequestSchema userRequestSchema, Map<String, String> additionalHeaders) throws ApiException {
        UserRequestSchema localVarPostBody = userRequestSchema;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling createIdentitySourceUser");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/users".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteIdentitySourceSession(String identitySourceId, String sessionId) throws ApiException {
        this.deleteIdentitySourceSession(identitySourceId, sessionId, Collections.emptyMap());
    }

    public void deleteIdentitySourceSession(String identitySourceId, String sessionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling deleteIdentitySourceSession");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling deleteIdentitySourceSession");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteIdentitySourceUser(String identitySourceId, String externalId) throws ApiException {
        this.deleteIdentitySourceUser(identitySourceId, externalId, Collections.emptyMap());
    }

    public void deleteIdentitySourceUser(String identitySourceId, String externalId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling deleteIdentitySourceUser");
        }
        if (externalId == null) {
            throw new ApiException(400, "Missing the required parameter 'externalId' when calling deleteIdentitySourceUser");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/users/{externalId}".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{externalId\\}", this.apiClient.escapeString(externalId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public IdentitySourceSession getIdentitySourceSession(String identitySourceId, String sessionId) throws ApiException {
        return this.getIdentitySourceSession(identitySourceId, sessionId, Collections.emptyMap());
    }

    public IdentitySourceSession getIdentitySourceSession(String identitySourceId, String sessionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling getIdentitySourceSession");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling getIdentitySourceSession");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentitySourceSession> localVarReturnType = new TypeReference<IdentitySourceSession>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserResponseSchema getIdentitySourceUser(String identitySourceId, String externalId) throws ApiException {
        return this.getIdentitySourceUser(identitySourceId, externalId, Collections.emptyMap());
    }

    public UserResponseSchema getIdentitySourceUser(String identitySourceId, String externalId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling getIdentitySourceUser");
        }
        if (externalId == null) {
            throw new ApiException(400, "Missing the required parameter 'externalId' when calling getIdentitySourceUser");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/users/{externalId}".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{externalId\\}", this.apiClient.escapeString(externalId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserResponseSchema> localVarReturnType = new TypeReference<UserResponseSchema>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IdentitySourceSession> listIdentitySourceSessions(String identitySourceId) throws ApiException {
        return this.listIdentitySourceSessions(identitySourceId, Collections.emptyMap());
    }

    public List<IdentitySourceSession> listIdentitySourceSessions(String identitySourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling listIdentitySourceSessions");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdentitySourceSession>> localVarReturnType = new TypeReference<List<IdentitySourceSession>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<IdentitySourceSession> listIdentitySourceSessionsPaged(String identitySourceId) {
        return this.listIdentitySourceSessionsPaged(identitySourceId, Collections.emptyMap());
    }

    public Iterable<IdentitySourceSession> listIdentitySourceSessionsPaged(String identitySourceId, Map<String, String> additionalHeaders) {
        return new PagedIterable<IdentitySourceSession>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<IdentitySourceSession>> localVarReturnType = new TypeReference<List<IdentitySourceSession>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<IdentitySourceSession>> localVarReturnType = new TypeReference<List<IdentitySourceSession>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public UserResponseSchema replaceExistingIdentitySourceUser(String identitySourceId, String externalId, UserRequestSchema userRequestSchema) throws ApiException {
        return this.replaceExistingIdentitySourceUser(identitySourceId, externalId, userRequestSchema, Collections.emptyMap());
    }

    public UserResponseSchema replaceExistingIdentitySourceUser(String identitySourceId, String externalId, UserRequestSchema userRequestSchema, Map<String, String> additionalHeaders) throws ApiException {
        UserRequestSchema localVarPostBody = userRequestSchema;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling replaceExistingIdentitySourceUser");
        }
        if (externalId == null) {
            throw new ApiException(400, "Missing the required parameter 'externalId' when calling replaceExistingIdentitySourceUser");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/users/{externalId}".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{externalId\\}", this.apiClient.escapeString(externalId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserResponseSchema> localVarReturnType = new TypeReference<UserResponseSchema>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdentitySourceSession startImportFromIdentitySource(String identitySourceId, String sessionId) throws ApiException {
        return this.startImportFromIdentitySource(identitySourceId, sessionId, Collections.emptyMap());
    }

    public IdentitySourceSession startImportFromIdentitySource(String identitySourceId, String sessionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling startImportFromIdentitySource");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling startImportFromIdentitySource");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/start-import".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentitySourceSession> localVarReturnType = new TypeReference<IdentitySourceSession>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserResponseSchema updateIdentitySourceUsers(String identitySourceId, String externalId, UsersUpdateRequestSchema usersUpdateRequestSchema) throws ApiException {
        return this.updateIdentitySourceUsers(identitySourceId, externalId, usersUpdateRequestSchema, Collections.emptyMap());
    }

    public UserResponseSchema updateIdentitySourceUsers(String identitySourceId, String externalId, UsersUpdateRequestSchema usersUpdateRequestSchema, Map<String, String> additionalHeaders) throws ApiException {
        UsersUpdateRequestSchema localVarPostBody = usersUpdateRequestSchema;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling updateIdentitySourceUsers");
        }
        if (externalId == null) {
            throw new ApiException(400, "Missing the required parameter 'externalId' when calling updateIdentitySourceUsers");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/users/{externalId}".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{externalId\\}", this.apiClient.escapeString(externalId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserResponseSchema> localVarReturnType = new TypeReference<UserResponseSchema>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void uploadIdentitySourceDataForDelete(String identitySourceId, String sessionId, BulkDeleteRequestBody bulkDeleteRequestBody) throws ApiException {
        this.uploadIdentitySourceDataForDelete(identitySourceId, sessionId, bulkDeleteRequestBody, Collections.emptyMap());
    }

    public void uploadIdentitySourceDataForDelete(String identitySourceId, String sessionId, BulkDeleteRequestBody bulkDeleteRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        BulkDeleteRequestBody localVarPostBody = bulkDeleteRequestBody;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceDataForDelete");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadIdentitySourceDataForDelete");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-delete".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void uploadIdentitySourceDataForUpsert(String identitySourceId, String sessionId, BulkUpsertRequestBody bulkUpsertRequestBody) throws ApiException {
        this.uploadIdentitySourceDataForUpsert(identitySourceId, sessionId, bulkUpsertRequestBody, Collections.emptyMap());
    }

    public void uploadIdentitySourceDataForUpsert(String identitySourceId, String sessionId, BulkUpsertRequestBody bulkUpsertRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        BulkUpsertRequestBody localVarPostBody = bulkUpsertRequestBody;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceDataForUpsert");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadIdentitySourceDataForUpsert");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-upsert".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void uploadIdentitySourceGroupMembershipsForDelete(String identitySourceId, String sessionId, BulkGroupMembershipsDeleteRequestBody bulkGroupMembershipsDeleteRequestBody) throws ApiException {
        this.uploadIdentitySourceGroupMembershipsForDelete(identitySourceId, sessionId, bulkGroupMembershipsDeleteRequestBody, Collections.emptyMap());
    }

    public void uploadIdentitySourceGroupMembershipsForDelete(String identitySourceId, String sessionId, BulkGroupMembershipsDeleteRequestBody bulkGroupMembershipsDeleteRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        BulkGroupMembershipsDeleteRequestBody localVarPostBody = bulkGroupMembershipsDeleteRequestBody;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceGroupMembershipsForDelete");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadIdentitySourceGroupMembershipsForDelete");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-group-memberships-delete".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void uploadIdentitySourceGroupMembershipsForUpsert(String identitySourceId, String sessionId, BulkGroupMembershipsUpsertRequestBody bulkGroupMembershipsUpsertRequestBody) throws ApiException {
        this.uploadIdentitySourceGroupMembershipsForUpsert(identitySourceId, sessionId, bulkGroupMembershipsUpsertRequestBody, Collections.emptyMap());
    }

    public void uploadIdentitySourceGroupMembershipsForUpsert(String identitySourceId, String sessionId, BulkGroupMembershipsUpsertRequestBody bulkGroupMembershipsUpsertRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        BulkGroupMembershipsUpsertRequestBody localVarPostBody = bulkGroupMembershipsUpsertRequestBody;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceGroupMembershipsForUpsert");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadIdentitySourceGroupMembershipsForUpsert");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-group-memberships-upsert".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void uploadIdentitySourceGroupsDataForDelete(String identitySourceId, String sessionId, BulkGroupDeleteRequestBody bulkGroupDeleteRequestBody) throws ApiException {
        this.uploadIdentitySourceGroupsDataForDelete(identitySourceId, sessionId, bulkGroupDeleteRequestBody, Collections.emptyMap());
    }

    public void uploadIdentitySourceGroupsDataForDelete(String identitySourceId, String sessionId, BulkGroupDeleteRequestBody bulkGroupDeleteRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        BulkGroupDeleteRequestBody localVarPostBody = bulkGroupDeleteRequestBody;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceGroupsDataForDelete");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadIdentitySourceGroupsDataForDelete");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-groups-delete".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void uploadIdentitySourceGroupsForUpsert(String identitySourceId, String sessionId, BulkGroupUpsertRequestBody bulkGroupUpsertRequestBody) throws ApiException {
        this.uploadIdentitySourceGroupsForUpsert(identitySourceId, sessionId, bulkGroupUpsertRequestBody, Collections.emptyMap());
    }

    public void uploadIdentitySourceGroupsForUpsert(String identitySourceId, String sessionId, BulkGroupUpsertRequestBody bulkGroupUpsertRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        BulkGroupUpsertRequestBody localVarPostBody = bulkGroupUpsertRequestBody;
        if (identitySourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceGroupsForUpsert");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadIdentitySourceGroupsForUpsert");
        }
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-groups-upsert".replaceAll("\\{identitySourceId\\}", this.apiClient.escapeString(identitySourceId.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

