/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.client;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadingWarningUtil {
    private static final Logger log = LoggerFactory.getLogger(MultiThreadingWarningUtil.class);
    private static final int THREAD_COUNT_WARNING_THRESHOLD = 3;
    private static final int MAX_TRACKED_THREADS = 1000;
    private final Set<Long> accessedThreadIds = ConcurrentHashMap.newKeySet();
    private final AtomicInteger uniqueThreadCount = new AtomicInteger(0);
    private final AtomicBoolean multiThreadWarningEmitted = new AtomicBoolean(false);
    private final AtomicBoolean threadPoolWarningEmitted = new AtomicBoolean(false);
    private final AtomicBoolean maxThreadsReachedWarningEmitted = new AtomicBoolean(false);

    public void recordThreadAccess() {
        long currentThreadId = Thread.currentThread().getId();
        String currentThreadName = Thread.currentThread().getName();
        if (this.uniqueThreadCount.get() >= 1000) {
            if (this.maxThreadsReachedWarningEmitted.compareAndSet(false, true)) {
                log.warn("OKTA SDK WARNING: Maximum tracked threads ({}) exceeded. Stopping thread tracking to prevent memory issues. This indicates excessive thread churn. The Okta SDK is not designed for high-concurrency, multi-threaded usage with a single ApiClient instance.", (Object)1000);
            }
            return;
        }
        if (!this.accessedThreadIds.add(currentThreadId)) {
            return;
        }
        int threadCount = this.uniqueThreadCount.getAndUpdate(count -> count >= 1000 ? count : count + 1);
        if (threadCount >= 1000) {
            this.accessedThreadIds.remove(currentThreadId);
            if (this.maxThreadsReachedWarningEmitted.compareAndSet(false, true)) {
                log.warn("OKTA SDK WARNING: Maximum tracked threads ({}) exceeded. Stopping thread tracking to prevent memory issues. This indicates excessive thread churn. The Okta SDK is not designed for high-concurrency, multi-threaded usage with a single ApiClient instance.", (Object)1000);
            }
            return;
        }
        log.debug("New thread detected accessing Okta SDK: {} (ID: {}). Total unique threads: {}", new Object[]{currentThreadName, currentThreadId, ++threadCount});
        if (threadCount > 3 && this.multiThreadWarningEmitted.compareAndSet(false, true)) {
            this.emitMultiThreadingWarning(threadCount);
        }
        if (threadCount > 1 && this.isLikelyThreadPoolThread(currentThreadName) && this.threadPoolWarningEmitted.compareAndSet(false, true)) {
            this.emitThreadPoolWarning();
        }
    }

    public int getUniqueThreadCount() {
        return this.uniqueThreadCount.get();
    }

    private boolean isLikelyThreadPoolThread(String threadName) {
        if (threadName == null) {
            return false;
        }
        String lowerName = threadName.toLowerCase();
        return lowerName.contains("pool") || lowerName.contains("worker") || lowerName.contains("executor") || lowerName.contains("thread-") || lowerName.contains("exec-");
    }

    private void emitMultiThreadingWarning(int threadCount) {
        log.warn("\n================================================================================\nOKTA SDK MULTI-THREADING WARNING\n================================================================================\nThe Okta SDK has detected that {} unique threads are accessing the same\nApiClient instance. The SDK stores pagination metadata per thread and is\nNOT designed for concurrent, multi-threaded usage patterns.\n\nPOTENTIAL ISSUES:\n  - Pagination may behave unexpectedly when multiple threads make requests\n  - Thread state may interfere between concurrent operations\n  - In thread pool environments, per-thread state persists across requests\n\nRECOMMENDATIONS:\n  1. Use a separate ApiClient instance per thread (thread-local pattern)\n  2. Synchronize access to a shared ApiClient instance (not recommended for\n     high-concurrency scenarios due to performance impact)\n  3. Avoid using the SDK's collection/pagination methods in multi-threaded\n     contexts where threads share an ApiClient instance\n\nFor more information, see: https://github.com/okta/okta-sdk-java/issues/1637\n================================================================================\n", (Object)threadCount);
    }

    private void emitThreadPoolWarning() {
        log.warn("\n================================================================================\nOKTA SDK THREAD POOL WARNING\n================================================================================\nThe Okta SDK has detected thread pool usage (e.g., in a web server or\nasync framework). This usage pattern has specific concerns:\n\nTHREAD POOL ISSUE:\n  - Thread pool threads are reused and live for the lifetime of the application\n  - Per-thread state from one request can leak into subsequent requests\n    handled by the same thread\n  - Pagination state from Request A might unexpectedly affect Request B\n\nRECOMMENDED PATTERNS FOR WEB SERVERS:\n  1. Create a new ApiClient per request (safest, but has overhead)\n  2. Use a thread-local ApiClient pattern:\n     \n     private static final ThreadLocal<ApiClient> CLIENT_HOLDER =\n         ThreadLocal.withInitial(() -> createNewApiClient());\n     \n  3. If using Spring, consider request-scoped beans\n  4. Avoid storing pagination state across HTTP requests\n\nFor more information, see: https://github.com/okta/okta-sdk-java/issues/1637\n================================================================================\n");
    }

    public void reset() {
        this.accessedThreadIds.clear();
        this.uniqueThreadCount.set(0);
        this.multiThreadWarningEmitted.set(false);
        this.threadPoolWarningEmitted.set(false);
        this.maxThreadsReachedWarningEmitted.set(false);
    }
}

