/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.WellKnownSSFMetadataSpecUrn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata about Okta as a transmitter and relevant information for configuration.")
@JsonPropertyOrder(value={"authorization_schemes", "configuration_endpoint", "default_subjects", "delivery_methods_supported", "issuer", "jwks_uri", "spec_version", "verification_endpoint"})
public class WellKnownSSFMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHORIZATION_SCHEMES = "authorization_schemes";
    private List<WellKnownSSFMetadataSpecUrn> authorizationSchemes = null;
    public static final String JSON_PROPERTY_CONFIGURATION_ENDPOINT = "configuration_endpoint";
    private URI configurationEndpoint;
    public static final String JSON_PROPERTY_DEFAULT_SUBJECTS = "default_subjects";
    private DefaultSubjectsEnum defaultSubjects;
    public static final String JSON_PROPERTY_DELIVERY_METHODS_SUPPORTED = "delivery_methods_supported";
    private List<URI> deliveryMethodsSupported = null;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private URI jwksUri;
    public static final String JSON_PROPERTY_SPEC_VERSION = "spec_version";
    private String specVersion;
    public static final String JSON_PROPERTY_VERIFICATION_ENDPOINT = "verification_endpoint";
    private URI verificationEndpoint;

    public WellKnownSSFMetadata authorizationSchemes(List<WellKnownSSFMetadataSpecUrn> authorizationSchemes) {
        this.authorizationSchemes = authorizationSchemes;
        return this;
    }

    public WellKnownSSFMetadata addauthorizationSchemesItem(WellKnownSSFMetadataSpecUrn authorizationSchemesItem) {
        if (this.authorizationSchemes == null) {
            this.authorizationSchemes = new ArrayList<WellKnownSSFMetadataSpecUrn>();
        }
        this.authorizationSchemes.add(authorizationSchemesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of JSON objects that specify the authorization scheme properties supported by the transmitter")
    @JsonProperty(value="authorization_schemes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WellKnownSSFMetadataSpecUrn> getAuthorizationSchemes() {
        return this.authorizationSchemes;
    }

    @JsonProperty(value="authorization_schemes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationSchemes(List<WellKnownSSFMetadataSpecUrn> authorizationSchemes) {
        this.authorizationSchemes = authorizationSchemes;
    }

    public WellKnownSSFMetadata configurationEndpoint(URI configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}/api/v1/ssf/stream", value="The URL of the SSF Stream configuration endpoint")
    @JsonProperty(value="configuration_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getConfigurationEndpoint() {
        return this.configurationEndpoint;
    }

    @JsonProperty(value="configuration_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfigurationEndpoint(URI configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
    }

    public WellKnownSSFMetadata defaultSubjects(DefaultSubjectsEnum defaultSubjects) {
        this.defaultSubjects = defaultSubjects;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A string that indicates the default behavior of newly created streams")
    @JsonProperty(value="default_subjects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DefaultSubjectsEnum getDefaultSubjects() {
        return this.defaultSubjects;
    }

    @JsonProperty(value="default_subjects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultSubjects(DefaultSubjectsEnum defaultSubjects) {
        this.defaultSubjects = defaultSubjects;
    }

    public WellKnownSSFMetadata deliveryMethodsSupported(List<URI> deliveryMethodsSupported) {
        this.deliveryMethodsSupported = deliveryMethodsSupported;
        return this;
    }

    public WellKnownSSFMetadata adddeliveryMethodsSupportedItem(URI deliveryMethodsSupportedItem) {
        if (this.deliveryMethodsSupported == null) {
            this.deliveryMethodsSupported = new ArrayList<URI>();
        }
        this.deliveryMethodsSupported.add(deliveryMethodsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"https://schemas.openid.net/secevent/risc/delivery-method/push\",\"urn:ietf:rfc:8935\"]", value="An array of supported SET delivery methods")
    @JsonProperty(value="delivery_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<URI> getDeliveryMethodsSupported() {
        return this.deliveryMethodsSupported;
    }

    @JsonProperty(value="delivery_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryMethodsSupported(List<URI> deliveryMethodsSupported) {
        this.deliveryMethodsSupported = deliveryMethodsSupported;
    }

    public WellKnownSSFMetadata issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}", value="The issuer used in Security Event Tokens. This value is set as `iss` in the claim.")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public WellKnownSSFMetadata jwksUri(URI jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}/oauth2/v1/keys", value="The URL of the JSON Web Key Set (JWKS) that contains the signing keys for validating the signatures of Security Event Tokens (SETs)")
    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getJwksUri() {
        return this.jwksUri;
    }

    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUri(URI jwksUri) {
        this.jwksUri = jwksUri;
    }

    public WellKnownSSFMetadata specVersion(String specVersion) {
        this.specVersion = specVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1_0-ID3", value="The version identifying the implementer's draft or final specification implemented by the transmitter")
    @JsonProperty(value="spec_version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpecVersion() {
        return this.specVersion;
    }

    @JsonProperty(value="spec_version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public WellKnownSSFMetadata verificationEndpoint(URI verificationEndpoint) {
        this.verificationEndpoint = verificationEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}/api/v1/ssf/stream/verification", value="The URL of the SSF Stream verification endpoint")
    @JsonProperty(value="verification_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getVerificationEndpoint() {
        return this.verificationEndpoint;
    }

    @JsonProperty(value="verification_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationEndpoint(URI verificationEndpoint) {
        this.verificationEndpoint = verificationEndpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WellKnownSSFMetadata wellKnownSSFMetadata = (WellKnownSSFMetadata)o;
        return Objects.equals(this.authorizationSchemes, wellKnownSSFMetadata.authorizationSchemes) && Objects.equals(this.configurationEndpoint, wellKnownSSFMetadata.configurationEndpoint) && Objects.equals((Object)this.defaultSubjects, (Object)wellKnownSSFMetadata.defaultSubjects) && Objects.equals(this.deliveryMethodsSupported, wellKnownSSFMetadata.deliveryMethodsSupported) && Objects.equals(this.issuer, wellKnownSSFMetadata.issuer) && Objects.equals(this.jwksUri, wellKnownSSFMetadata.jwksUri) && Objects.equals(this.specVersion, wellKnownSSFMetadata.specVersion) && Objects.equals(this.verificationEndpoint, wellKnownSSFMetadata.verificationEndpoint);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationSchemes, this.configurationEndpoint, this.defaultSubjects, this.deliveryMethodsSupported, this.issuer, this.jwksUri, this.specVersion, this.verificationEndpoint});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WellKnownSSFMetadata {\n");
        sb.append("    authorizationSchemes: ").append(this.toIndentedString(this.authorizationSchemes)).append("\n");
        sb.append("    configurationEndpoint: ").append(this.toIndentedString(this.configurationEndpoint)).append("\n");
        sb.append("    defaultSubjects: ").append(this.toIndentedString((Object)this.defaultSubjects)).append("\n");
        sb.append("    deliveryMethodsSupported: ").append(this.toIndentedString(this.deliveryMethodsSupported)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("    specVersion: ").append(this.toIndentedString(this.specVersion)).append("\n");
        sb.append("    verificationEndpoint: ").append(this.toIndentedString(this.verificationEndpoint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DefaultSubjectsEnum {
        ALL(String.valueOf("ALL")),
        NONE(String.valueOf("NONE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private DefaultSubjectsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DefaultSubjectsEnum fromValue(String value) {
            for (DefaultSubjectsEnum b : DefaultSubjectsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

