/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Verifies a `webauthn` factor challenge by posting a signed assertion using the challenge `nonce`")
@JsonPropertyOrder(value={"authenticatorData", "clientData", "signatureData"})
@JsonTypeName(value="webauthn_1")
public class Webauthn1
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHENTICATOR_DATA = "authenticatorData";
    private String authenticatorData;
    public static final String JSON_PROPERTY_CLIENT_DATA = "clientData";
    private String clientData;
    public static final String JSON_PROPERTY_SIGNATURE_DATA = "signatureData";
    private String signatureData;

    public Webauthn1 authenticatorData(String authenticatorData) {
        this.authenticatorData = authenticatorData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-encoded authenticator data from the WebAuthn authenticator")
    @JsonProperty(value="authenticatorData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthenticatorData() {
        return this.authenticatorData;
    }

    @JsonProperty(value="authenticatorData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorData(String authenticatorData) {
        this.authenticatorData = authenticatorData;
    }

    public Webauthn1 clientData(String clientData) {
        this.clientData = clientData;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJjaGFsbGVuZ2UiOiJVSk5wYW9sVWt0dF9vcEZPNXJMYyIsIm9yaWdpbiI6Imh0dHBzOi8vcmFpbi5va3RhMS5jb20iLCJ0eXBlIjoid2ViYXV0aG4uY3JlYXRlIn0", value="Base64-encoded client data from the WebAuthn authenticator")
    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientData() {
        return this.clientData;
    }

    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public Webauthn1 signatureData(String signatureData) {
        this.signatureData = signatureData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-encoded signature data from the WebAuthn authenticator")
    @JsonProperty(value="signatureData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignatureData() {
        return this.signatureData;
    }

    @JsonProperty(value="signatureData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatureData(String signatureData) {
        this.signatureData = signatureData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webauthn1 webauthn1 = (Webauthn1)o;
        return Objects.equals(this.authenticatorData, webauthn1.authenticatorData) && Objects.equals(this.clientData, webauthn1.clientData) && Objects.equals(this.signatureData, webauthn1.signatureData);
    }

    public int hashCode() {
        return Objects.hash(this.authenticatorData, this.clientData, this.signatureData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webauthn1 {\n");
        sb.append("    authenticatorData: ").append(this.toIndentedString(this.authenticatorData)).append("\n");
        sb.append("    clientData: ").append(this.toIndentedString(this.clientData)).append("\n");
        sb.append("    signatureData: ").append(this.toIndentedString(this.signatureData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

