/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DNSRecordAuthenticators;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The RP domain object for the WebAuthn configuration")
@JsonPropertyOrder(value={"dnsRecord", "name", "validationStatus"})
public class WebAuthnRpIdDomain
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DNS_RECORD = "dnsRecord";
    private DNSRecordAuthenticators dnsRecord;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_VALIDATION_STATUS = "validationStatus";
    private ValidationStatusEnum validationStatus;

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="dnsRecord")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DNSRecordAuthenticators getDnsRecord() {
        return this.dnsRecord;
    }

    public WebAuthnRpIdDomain name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mycustomdomain.com", value="The [RP ID](https://www.w3.org/TR/webauthn/#relying-party-identifier) domain value to be used for all WebAuthn operations.  If it isn't specified, the `domain` object isn't included in the request, and the domain value defaults to the domain of the current page (the domain of your org or a custom domain, for example).  > **Note:** If you don't use a custom RP ID (the default behavior), the domain value defaults to the end user's current page. The domain value defaults to the full domain name of the page that the end user is on when they're attempting the WebAuthn credential operation (enrollment or verification).")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(value="Indicates the validation status of the domain")
    @JsonProperty(value="validationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ValidationStatusEnum getValidationStatus() {
        return this.validationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnRpIdDomain webAuthnRpIdDomain = (WebAuthnRpIdDomain)o;
        return Objects.equals(this.dnsRecord, webAuthnRpIdDomain.dnsRecord) && Objects.equals(this.name, webAuthnRpIdDomain.name) && Objects.equals((Object)this.validationStatus, (Object)webAuthnRpIdDomain.validationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dnsRecord, this.name, this.validationStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebAuthnRpIdDomain {\n");
        sb.append("    dnsRecord: ").append(this.toIndentedString(this.dnsRecord)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    validationStatus: ").append(this.toIndentedString((Object)this.validationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ValidationStatusEnum {
        NOT_STARTED(String.valueOf("NOT_STARTED")),
        IN_PROGRESS(String.valueOf("IN_PROGRESS")),
        VERIFIED(String.valueOf("VERIFIED")),
        ERROR(String.valueOf("ERROR")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ValidationStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ValidationStatusEnum fromValue(String value) {
            for (ValidationStatusEnum b : ValidationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

