/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"passCode", "useNumberMatchingChallenge", "answer", "clientData", "signatureData", "authenticatorData"})
public class UserFactorVerifyRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PASS_CODE = "passCode";
    private String passCode;
    public static final String JSON_PROPERTY_USE_NUMBER_MATCHING_CHALLENGE = "useNumberMatchingChallenge";
    private Boolean useNumberMatchingChallenge;
    public static final String JSON_PROPERTY_ANSWER = "answer";
    private String answer;
    public static final String JSON_PROPERTY_CLIENT_DATA = "clientData";
    private String clientData;
    public static final String JSON_PROPERTY_SIGNATURE_DATA = "signatureData";
    private String signatureData;
    public static final String JSON_PROPERTY_AUTHENTICATOR_DATA = "authenticatorData";
    private String authenticatorData;

    public UserFactorVerifyRequest passCode(String passCode) {
        this.passCode = passCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1234567890", value="OTP for the current time window")
    @JsonProperty(value="passCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassCode() {
        return this.passCode;
    }

    @JsonProperty(value="passCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassCode(String passCode) {
        this.passCode = passCode;
    }

    public UserFactorVerifyRequest useNumberMatchingChallenge(Boolean useNumberMatchingChallenge) {
        this.useNumberMatchingChallenge = useNumberMatchingChallenge;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Select whether to use a number matching challenge for a `push` factor.  > **Note:** Sending a request with a body is required when you verify a `push` factor with a number matching challenge.")
    @JsonProperty(value="useNumberMatchingChallenge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseNumberMatchingChallenge() {
        return this.useNumberMatchingChallenge;
    }

    @JsonProperty(value="useNumberMatchingChallenge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseNumberMatchingChallenge(Boolean useNumberMatchingChallenge) {
        this.useNumberMatchingChallenge = useNumberMatchingChallenge;
    }

    public UserFactorVerifyRequest answer(String answer) {
        this.answer = answer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Answer to the question")
    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAnswer() {
        return this.answer;
    }

    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public UserFactorVerifyRequest clientData(String clientData) {
        this.clientData = clientData;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJjaGFsbGVuZ2UiOiJVSk5wYW9sVWt0dF9vcEZPNXJMYyIsIm9yaWdpbiI6Imh0dHBzOi8vcmFpbi5va3RhMS5jb20iLCJ0eXBlIjoid2ViYXV0aG4uY3JlYXRlIn0", value="Base64-encoded client data from the WebAuthn authenticator")
    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientData() {
        return this.clientData;
    }

    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public UserFactorVerifyRequest signatureData(String signatureData) {
        this.signatureData = signatureData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-encoded signature data from the WebAuthn authenticator")
    @JsonProperty(value="signatureData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignatureData() {
        return this.signatureData;
    }

    @JsonProperty(value="signatureData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatureData(String signatureData) {
        this.signatureData = signatureData;
    }

    public UserFactorVerifyRequest authenticatorData(String authenticatorData) {
        this.authenticatorData = authenticatorData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-encoded authenticator data from the WebAuthn authenticator")
    @JsonProperty(value="authenticatorData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthenticatorData() {
        return this.authenticatorData;
    }

    @JsonProperty(value="authenticatorData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorData(String authenticatorData) {
        this.authenticatorData = authenticatorData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFactorVerifyRequest userFactorVerifyRequest = (UserFactorVerifyRequest)o;
        return Objects.equals(this.passCode, userFactorVerifyRequest.passCode) && Objects.equals(this.useNumberMatchingChallenge, userFactorVerifyRequest.useNumberMatchingChallenge) && Objects.equals(this.answer, userFactorVerifyRequest.answer) && Objects.equals(this.clientData, userFactorVerifyRequest.clientData) && Objects.equals(this.signatureData, userFactorVerifyRequest.signatureData) && Objects.equals(this.authenticatorData, userFactorVerifyRequest.authenticatorData);
    }

    public int hashCode() {
        return Objects.hash(this.passCode, this.useNumberMatchingChallenge, this.answer, this.clientData, this.signatureData, this.authenticatorData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorVerifyRequest {\n");
        sb.append("    passCode: ").append(this.toIndentedString(this.passCode)).append("\n");
        sb.append("    useNumberMatchingChallenge: ").append(this.toIndentedString(this.useNumberMatchingChallenge)).append("\n");
        sb.append("    answer: ").append(this.toIndentedString(this.answer)).append("\n");
        sb.append("    clientData: ").append(this.toIndentedString(this.clientData)).append("\n");
        sb.append("    signatureData: ").append(this.toIndentedString(this.signatureData)).append("\n");
        sb.append("    authenticatorData: ").append(this.toIndentedString(this.authenticatorData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

