/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Verifies a `u2f` factor challenge by posting a signed assertion using the challenge `nonce`")
@JsonPropertyOrder(value={"clientData", "signatureData"})
@JsonTypeName(value="u2f_1")
public class U2f1
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_DATA = "clientData";
    private String clientData;
    public static final String JSON_PROPERTY_SIGNATURE_DATA = "signatureData";
    private JsonNullable<Object> signatureData = JsonNullable.of(null);

    public U2f1 clientData(String clientData) {
        this.clientData = clientData;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJ0eXAiOiJuYXZpZ2F0b3IuaWQuZmluaXNoRW5yb2xsbWVudCIsImNoYWxsZW5nZSI6IlhxR0h0RTBoUkxuVEoxYUF5U1oyIiwib3JpZ2luIjoiaHR0cHM6Ly9sb2NhbGhvc3Q6MzAwMCIsImNpZF9wdWJrZXkiOiJ1bnVzZWQifQ", value="Base64-encoded client data from the U2F token")
    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientData() {
        return this.clientData;
    }

    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public U2f1 signatureData(Object signatureData) {
        this.signatureData = JsonNullable.of((Object)signatureData);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-encoded signature data from the U2F token")
    @JsonIgnore
    public Object getSignatureData() {
        return this.signatureData.orElse(null);
    }

    @JsonProperty(value="signatureData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getSignatureData_JsonNullable() {
        return this.signatureData;
    }

    @JsonProperty(value="signatureData")
    public void setSignatureData_JsonNullable(JsonNullable<Object> signatureData) {
        this.signatureData = signatureData;
    }

    public void setSignatureData(Object signatureData) {
        this.signatureData = JsonNullable.of((Object)signatureData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        U2f1 u2f1 = (U2f1)o;
        return Objects.equals(this.clientData, u2f1.clientData) && U2f1.equalsNullable(this.signatureData, u2f1.signatureData);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.clientData, U2f1.hashCodeNullable(this.signatureData));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class U2f1 {\n");
        sb.append("    clientData: ").append(this.toIndentedString(this.clientData)).append("\n");
        sb.append("    signatureData: ").append(this.toIndentedString(this.signatureData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

