/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Activates a `u2f` factor with the specified client and registration information from the U2F token")
@JsonPropertyOrder(value={"clientData", "registrationData"})
@JsonTypeName(value="u2f")
public class U2f
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_DATA = "clientData";
    private String clientData;
    public static final String JSON_PROPERTY_REGISTRATION_DATA = "registrationData";
    private String registrationData;

    public U2f clientData(String clientData) {
        this.clientData = clientData;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJ0eXAiOiJuYXZpZ2F0b3IuaWQuZmluaXNoRW5yb2xsbWVudCIsImNoYWxsZW5nZSI6IlhxR0h0RTBoUkxuVEoxYUF5U1oyIiwib3JpZ2luIjoiaHR0cHM6Ly9sb2NhbGhvc3Q6MzAwMCIsImNpZF9wdWJrZXkiOiJ1bnVzZWQifQ", value="Base64-encoded client data from the U2F token")
    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientData() {
        return this.clientData;
    }

    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public U2f registrationData(String registrationData) {
        this.registrationData = registrationData;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="BQTEMUyOM8h1TiZG4DL-RdMr-tYgTYSf62Y52AmwEFTiSYWIRVO5L-MwWdRJOthmV3J3JrqpmGfmFb820-awx1YIQFlTvkMhxItHlpkzahEqicpw7SIH9yMfTn2kaDcC6JaLKPfV5ds0vzuxF1JJj3gCM01bRC-HWI4nCVgc-zaaoRgwggEcMIHDoAMCAQICCwD52fCSMoNczORdMAoGCCqGSM49BAMCMBUxEzARBgNVBAMTClUyRiBJc3N1ZXIwGhcLMDAwMTAxMDAwMFoXCzAwMDEwMTAwMDBaMBUxEzARBgNVBAMTClUyRiBEZXZpY2UwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAAQFKJupuUgPQcRHUphaW5JPfLvkkwlEwlHKk_ntSp7MS4aTHJyGnpziqncrjiTC_oUVtb-wN-y_t_IMIjueGkhxMAoGCCqGSM49BAMCA0gAMEUCIQDBo6aOLxanIUYnBX9iu3KMngPnobpi0EZSTkVtLC8_cwIgC1945RGqGBKfbyNtkhMifZK05n7fU-gW37Bdnci5D94wRQIhAJv3VvclbRkHAQhaUR8rr8qFTg9iF-GtHoXU95vWaQdyAiAbEr-440U4dQAZF-Sj8G2fxgh5DkgkkWpyUHZhz7N9ew", value="Base64-encoded registration data from the U2F token")
    @JsonProperty(value="registrationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrationData() {
        return this.registrationData;
    }

    @JsonProperty(value="registrationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegistrationData(String registrationData) {
        this.registrationData = registrationData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        U2f u2f = (U2f)o;
        return Objects.equals(this.clientData, u2f.clientData) && Objects.equals(this.registrationData, u2f.registrationData);
    }

    public int hashCode() {
        return Objects.hash(this.clientData, this.registrationData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class U2f {\n");
        sb.append("    clientData: ").append(this.toIndentedString(this.clientData)).append("\n");
        sb.append("    registrationData: ").append(this.toIndentedString(this.registrationData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

