/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="SCIM test details")
@JsonPropertyOrder(value={"specTestResults", "crudTestResults", "entitlementsTestResults"})
@JsonTypeName(value="TestInfo_scimTestConfiguration")
public class TestInfoScimTestConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_SPEC_TEST_RESULTS = "specTestResults";
    private URI specTestResults;
    public static final String JSON_PROPERTY_CRUD_TEST_RESULTS = "crudTestResults";
    private URI crudTestResults;
    public static final String JSON_PROPERTY_ENTITLEMENTS_TEST_RESULTS = "entitlementsTestResults";
    private URI entitlementsTestResults;

    public TestInfoScimTestConfiguration specTestResults(URI specTestResults) {
        this.specTestResults = specTestResults;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://www.runscope.com/radar/abcdefghijkl/m01nopq2-3456-7r8s-9012-t34567uvw890/history/123ef4gh-i567-89j0-1k2l-3m4n5o678901", required=true, value="The Runscope URL to your SCIM server specification test results. See [Test your SCIM API](https://developer.okta.com/docs/guides/build-provisioning-integration/test-scim-api/).")
    @JsonProperty(value="specTestResults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getSpecTestResults() {
        return this.specTestResults;
    }

    @JsonProperty(value="specTestResults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSpecTestResults(URI specTestResults) {
        this.specTestResults = specTestResults;
    }

    public TestInfoScimTestConfiguration crudTestResults(URI crudTestResults) {
        this.crudTestResults = crudTestResults;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://www.runscope.com/radar/radfebnsefbd/msdfsvx2-3456-7r8s-9012-t34567uvw890/history/123ef4gh-i567-89j0-1k2l-cdgj455hw45u", required=true, value="The Runscope URL to your Okta SCIM CRUD test results. See [Test your Okta SCIM integration](https://developer.okta.com/docs/guides/scim-provisioning-integration-test/main/).")
    @JsonProperty(value="crudTestResults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getCrudTestResults() {
        return this.crudTestResults;
    }

    @JsonProperty(value="crudTestResults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCrudTestResults(URI crudTestResults) {
        this.crudTestResults = crudTestResults;
    }

    public TestInfoScimTestConfiguration entitlementsTestResults(URI entitlementsTestResults) {
        this.entitlementsTestResults = entitlementsTestResults;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.runscope.com/radar/fgdffghfghfg/m01nopq2-3456-7r8s-9012-t34567uvw890/history/123ef4gh-i567-89j0-1k2l-r434565g5451", value="The Runscope URL to your entitlements test results")
    @JsonProperty(value="entitlementsTestResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getEntitlementsTestResults() {
        return this.entitlementsTestResults;
    }

    @JsonProperty(value="entitlementsTestResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntitlementsTestResults(URI entitlementsTestResults) {
        this.entitlementsTestResults = entitlementsTestResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestInfoScimTestConfiguration testInfoScimTestConfiguration = (TestInfoScimTestConfiguration)o;
        return Objects.equals(this.specTestResults, testInfoScimTestConfiguration.specTestResults) && Objects.equals(this.crudTestResults, testInfoScimTestConfiguration.crudTestResults) && Objects.equals(this.entitlementsTestResults, testInfoScimTestConfiguration.entitlementsTestResults);
    }

    public int hashCode() {
        return Objects.hash(this.specTestResults, this.crudTestResults, this.entitlementsTestResults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestInfoScimTestConfiguration {\n");
        sb.append("    specTestResults: ").append(this.toIndentedString(this.specTestResults)).append("\n");
        sb.append("    crudTestResults: ").append(this.toIndentedString(this.crudTestResults)).append("\n");
        sb.append("    entitlementsTestResults: ").append(this.toIndentedString(this.entitlementsTestResults)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

