/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.TelephonyRequestData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Telephony inline hook request body")
@JsonPropertyOrder(value={"cloudEventVersion", "contentType", "eventId", "eventTime", "eventTypeVersion", "data", "eventType", "requestType", "source"})
public class TelephonyRequestExecute
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLOUD_EVENT_VERSION = "cloudEventVersion";
    private String cloudEventVersion;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    private String contentType;
    public static final String JSON_PROPERTY_EVENT_ID = "eventId";
    private String eventId;
    public static final String JSON_PROPERTY_EVENT_TIME = "eventTime";
    private String eventTime;
    public static final String JSON_PROPERTY_EVENT_TYPE_VERSION = "eventTypeVersion";
    private String eventTypeVersion;
    public static final String JSON_PROPERTY_DATA = "data";
    private TelephonyRequestData data;
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private String eventType;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
    private String requestType;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private String source;

    public TelephonyRequestExecute cloudEventVersion(String cloudEventVersion) {
        this.cloudEventVersion = cloudEventVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The inline hook cloud version")
    @JsonProperty(value="cloudEventVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCloudEventVersion() {
        return this.cloudEventVersion;
    }

    @JsonProperty(value="cloudEventVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloudEventVersion(String cloudEventVersion) {
        this.cloudEventVersion = cloudEventVersion;
    }

    public TelephonyRequestExecute contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="application/JSON", value="The inline hook request header content")
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public TelephonyRequestExecute eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3o9jBzq1SmOGmmsDsqyyeQ", value="The individual inline hook request ID")
    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public TelephonyRequestExecute eventTime(String eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-01-17T21:23:56.000Z", value="The time the inline hook request was sent")
    @JsonProperty(value="eventTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventTime() {
        return this.eventTime;
    }

    @JsonProperty(value="eventTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public TelephonyRequestExecute eventTypeVersion(String eventTypeVersion) {
        this.eventTypeVersion = eventTypeVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The inline hook version")
    @JsonProperty(value="eventTypeVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventTypeVersion() {
        return this.eventTypeVersion;
    }

    @JsonProperty(value="eventTypeVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventTypeVersion(String eventTypeVersion) {
        this.eventTypeVersion = eventTypeVersion;
    }

    public TelephonyRequestExecute data(TelephonyRequestData data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TelephonyRequestData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(TelephonyRequestData data) {
        this.data = data;
    }

    public TelephonyRequestExecute eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of inline hook. The telephony inline hook type is `com.okta.telephony.provider`.")
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public TelephonyRequestExecute requestType(String requestType) {
        this.requestType = requestType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of inline hook request. For example, `com.okta.user.telephony.pre-enrollment`.")
    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public TelephonyRequestExecute source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID and URL of the telephony inline hook")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelephonyRequestExecute telephonyRequestExecute = (TelephonyRequestExecute)o;
        return Objects.equals(this.cloudEventVersion, telephonyRequestExecute.cloudEventVersion) && Objects.equals(this.contentType, telephonyRequestExecute.contentType) && Objects.equals(this.eventId, telephonyRequestExecute.eventId) && Objects.equals(this.eventTime, telephonyRequestExecute.eventTime) && Objects.equals(this.eventTypeVersion, telephonyRequestExecute.eventTypeVersion) && Objects.equals(this.data, telephonyRequestExecute.data) && Objects.equals(this.eventType, telephonyRequestExecute.eventType) && Objects.equals(this.requestType, telephonyRequestExecute.requestType) && Objects.equals(this.source, telephonyRequestExecute.source);
    }

    public int hashCode() {
        return Objects.hash(this.cloudEventVersion, this.contentType, this.eventId, this.eventTime, this.eventTypeVersion, this.data, this.eventType, this.requestType, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelephonyRequestExecute {\n");
        sb.append("    cloudEventVersion: ").append(this.toIndentedString(this.cloudEventVersion)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventTypeVersion: ").append(this.toIndentedString(this.eventTypeVersion)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString(this.requestType)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

