/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="`GROUP` attribute statements")
@JsonPropertyOrder(value={"filterType", "filterValue", "name", "namespace", "type"})
public class SamlAttributeStatementGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_FILTER_TYPE = "filterType";
    private FilterTypeEnum filterType;
    public static final String JSON_PROPERTY_FILTER_VALUE = "filterValue";
    private String filterValue;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    private NamespaceEnum namespace;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public SamlAttributeStatementGroup filterType(FilterTypeEnum filterType) {
        this.filterType = filterType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The operation to filter groups based on `filterValue`")
    @JsonProperty(value="filterType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FilterTypeEnum getFilterType() {
        return this.filterType;
    }

    @JsonProperty(value="filterType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterType(FilterTypeEnum filterType) {
        this.filterType = filterType;
    }

    public SamlAttributeStatementGroup filterValue(String filterValue) {
        this.filterValue = filterValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Team", value="Filter the groups based on a specific value.")
    @JsonProperty(value="filterValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilterValue() {
        return this.filterValue;
    }

    @JsonProperty(value="filterValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    public SamlAttributeStatementGroup name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the group attribute in your app. The attribute name must be unique across all user and group attribute statements.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SamlAttributeStatementGroup namespace(NamespaceEnum namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="urn:oasis:names:tc:SAML:2.0:attrname-format:basic", value="The name format of the group attribute. Supported values:")
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NamespaceEnum getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNamespace(NamespaceEnum namespace) {
        this.namespace = namespace;
    }

    public SamlAttributeStatementGroup type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GROUP", value="The type of attribute statements object")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlAttributeStatementGroup samlAttributeStatementGroup = (SamlAttributeStatementGroup)o;
        return Objects.equals((Object)this.filterType, (Object)samlAttributeStatementGroup.filterType) && Objects.equals(this.filterValue, samlAttributeStatementGroup.filterValue) && Objects.equals(this.name, samlAttributeStatementGroup.name) && Objects.equals((Object)this.namespace, (Object)samlAttributeStatementGroup.namespace) && Objects.equals((Object)this.type, (Object)samlAttributeStatementGroup.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterType, this.filterValue, this.name, this.namespace, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlAttributeStatementGroup {\n");
        sb.append("    filterType: ").append(this.toIndentedString((Object)this.filterType)).append("\n");
        sb.append("    filterValue: ").append(this.toIndentedString(this.filterValue)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString((Object)this.namespace)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FilterTypeEnum {
        STARTS_WITH(String.valueOf("STARTS_WITH")),
        EQUALS(String.valueOf("EQUALS")),
        CONTAINS(String.valueOf("CONTAINS")),
        REGEX(String.valueOf("REGEX")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FilterTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FilterTypeEnum fromValue(String value) {
            for (FilterTypeEnum b : FilterTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum NamespaceEnum {
        URN_OASIS_NAMES_TC_SAML_2_0_ATTRNAME_FORMAT_BASIC(String.valueOf("urn:oasis:names:tc:SAML:2.0:attrname-format:basic")),
        URN_OASIS_NAMES_TC_SAML_2_0_ATTRNAME_FORMAT_URI(String.valueOf("urn:oasis:names:tc:SAML:2.0:attrname-format:uri")),
        URN_OASIS_NAMES_TC_SAML_2_0_ATTRNAME_FORMAT_UNSPECIFIED(String.valueOf("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private NamespaceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NamespaceEnum fromValue(String value) {
            for (NamespaceEnum b : NamespaceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum TypeEnum {
        GROUP(String.valueOf("GROUP")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

