/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.LinksSelf;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"assignmentType", "expiration", "orn", "_links"})
public class RoleTarget
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ASSIGNMENT_TYPE = "assignmentType";
    private String assignmentType;
    public static final String JSON_PROPERTY_EXPIRATION = "expiration";
    private OffsetDateTime expiration;
    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    @Nullable
    @ApiModelProperty(example="GROUP", value="The assignment type of how the user receives this target")
    @JsonProperty(value="assignmentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssignmentType() {
        return this.assignmentType;
    }

    @Nullable
    @ApiModelProperty(example="2023-08-25T12:00Z", value="The expiry time stamp of the associated target. It's only included in the response if the associated target will expire.")
    @JsonProperty(value="expiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    @Nullable
    @ApiModelProperty(example="orn:okta:directory:00o5v1t2W4OSF9r4N0g4:groups:00g5vhi3rEJMOog1S0g4", value="The [Okta Resource Name (ORN)](https://support.okta.com/help/s/article/understanding-okta-resource-name-orn) of the app target or group target")
    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrn() {
        return this.orn;
    }

    public RoleTarget links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleTarget roleTarget = (RoleTarget)o;
        return Objects.equals(this.assignmentType, roleTarget.assignmentType) && Objects.equals(this.expiration, roleTarget.expiration) && Objects.equals(this.orn, roleTarget.orn) && Objects.equals(this.links, roleTarget.links);
    }

    public int hashCode() {
        return Objects.hash(this.assignmentType, this.expiration, this.orn, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleTarget {\n");
        sb.append("    assignmentType: ").append(this.toIndentedString(this.assignmentType)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    orn: ").append(this.toIndentedString(this.orn)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

