/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticationMethodObject;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"authenticationMethods", "excludedAuthenticationMethods", "methods", "reauthenticateIn", "required", "types", "deviceBound", "hardwareProtection", "phishingResistant", "userPresence", "userVerification", "userVerificationMethods"})
public class PossessionConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHENTICATION_METHODS = "authenticationMethods";
    private List<AuthenticationMethodObject> authenticationMethods = null;
    public static final String JSON_PROPERTY_EXCLUDED_AUTHENTICATION_METHODS = "excludedAuthenticationMethods";
    private List<AuthenticationMethodObject> excludedAuthenticationMethods = null;
    public static final String JSON_PROPERTY_METHODS = "methods";
    private List<MethodsEnum> methods = null;
    public static final String JSON_PROPERTY_REAUTHENTICATE_IN = "reauthenticateIn";
    private String reauthenticateIn;
    public static final String JSON_PROPERTY_REQUIRED = "required";
    private Boolean required;
    public static final String JSON_PROPERTY_TYPES = "types";
    private List<TypesEnum> types = null;
    public static final String JSON_PROPERTY_DEVICE_BOUND = "deviceBound";
    private DeviceBoundEnum deviceBound = DeviceBoundEnum.OPTIONAL;
    public static final String JSON_PROPERTY_HARDWARE_PROTECTION = "hardwareProtection";
    private HardwareProtectionEnum hardwareProtection = HardwareProtectionEnum.OPTIONAL;
    public static final String JSON_PROPERTY_PHISHING_RESISTANT = "phishingResistant";
    private PhishingResistantEnum phishingResistant = PhishingResistantEnum.OPTIONAL;
    public static final String JSON_PROPERTY_USER_PRESENCE = "userPresence";
    private UserPresenceEnum userPresence = UserPresenceEnum.REQUIRED;
    public static final String JSON_PROPERTY_USER_VERIFICATION = "userVerification";
    private UserVerificationEnum userVerification = UserVerificationEnum.OPTIONAL;
    public static final String JSON_PROPERTY_USER_VERIFICATION_METHODS = "userVerificationMethods";
    private List<UserVerificationMethodsEnum> userVerificationMethods = null;

    public PossessionConstraint authenticationMethods(List<AuthenticationMethodObject> authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
        return this;
    }

    public PossessionConstraint addauthenticationMethodsItem(AuthenticationMethodObject authenticationMethodsItem) {
        if (this.authenticationMethods == null) {
            this.authenticationMethods = new ArrayList<AuthenticationMethodObject>();
        }
        this.authenticationMethods.add(authenticationMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This property specifies the precise authenticator and method for authentication. <x-lifecycle class=\"oie\"></x-lifecycle>")
    @JsonProperty(value="authenticationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthenticationMethodObject> getAuthenticationMethods() {
        return this.authenticationMethods;
    }

    @JsonProperty(value="authenticationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationMethods(List<AuthenticationMethodObject> authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
    }

    public PossessionConstraint excludedAuthenticationMethods(List<AuthenticationMethodObject> excludedAuthenticationMethods) {
        this.excludedAuthenticationMethods = excludedAuthenticationMethods;
        return this;
    }

    public PossessionConstraint addexcludedAuthenticationMethodsItem(AuthenticationMethodObject excludedAuthenticationMethodsItem) {
        if (this.excludedAuthenticationMethods == null) {
            this.excludedAuthenticationMethods = new ArrayList<AuthenticationMethodObject>();
        }
        this.excludedAuthenticationMethods.add(excludedAuthenticationMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This property specifies the precise authenticator and method to exclude from authentication. <x-lifecycle class=\"oie\"></x-lifecycle>")
    @JsonProperty(value="excludedAuthenticationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthenticationMethodObject> getExcludedAuthenticationMethods() {
        return this.excludedAuthenticationMethods;
    }

    @JsonProperty(value="excludedAuthenticationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludedAuthenticationMethods(List<AuthenticationMethodObject> excludedAuthenticationMethods) {
        this.excludedAuthenticationMethods = excludedAuthenticationMethods;
    }

    public PossessionConstraint methods(List<MethodsEnum> methods) {
        this.methods = methods;
        return this;
    }

    public PossessionConstraint addmethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authenticator methods that are permitted")
    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MethodsEnum> getMethods() {
        return this.methods;
    }

    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public PossessionConstraint reauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The duration after which the user must re-authenticate regardless of user activity. This re-authentication interval overrides the Verification Method object's `reauthenticateIn` interval. The supported values use ISO 8601 period format for recurring time intervals (for example, `PT1H`).")
    @JsonProperty(value="reauthenticateIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReauthenticateIn() {
        return this.reauthenticateIn;
    }

    @JsonProperty(value="reauthenticateIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
    }

    public PossessionConstraint required(Boolean required) {
        this.required = required;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This property indicates whether the knowledge or possession factor is required by the assurance. It's optional in the request, but is always returned in the response. By default, this field is `true`. If the knowledge or possession constraint has values for `excludedAuthenticationMethods` the `required` value is false. <x-lifecycle class=\"oie\"></x-lifecycle>")
    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    public PossessionConstraint types(List<TypesEnum> types) {
        this.types = types;
        return this;
    }

    public PossessionConstraint addtypesItem(TypesEnum typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<TypesEnum>();
        }
        this.types.add(typesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authenticator types that are permitted")
    @JsonProperty(value="types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TypesEnum> getTypes() {
        return this.types;
    }

    @JsonProperty(value="types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypes(List<TypesEnum> types) {
        this.types = types;
    }

    public PossessionConstraint deviceBound(DeviceBoundEnum deviceBound) {
        this.deviceBound = deviceBound;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if device-bound Factors are required. This property is only set for `POSSESSION` constraints.")
    @JsonProperty(value="deviceBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeviceBoundEnum getDeviceBound() {
        return this.deviceBound;
    }

    @JsonProperty(value="deviceBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceBound(DeviceBoundEnum deviceBound) {
        this.deviceBound = deviceBound;
    }

    public PossessionConstraint hardwareProtection(HardwareProtectionEnum hardwareProtection) {
        this.hardwareProtection = hardwareProtection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if any secrets or private keys used during authentication must be hardware protected and not exportable. This property is only set for `POSSESSION` constraints.")
    @JsonProperty(value="hardwareProtection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HardwareProtectionEnum getHardwareProtection() {
        return this.hardwareProtection;
    }

    @JsonProperty(value="hardwareProtection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHardwareProtection(HardwareProtectionEnum hardwareProtection) {
        this.hardwareProtection = hardwareProtection;
    }

    public PossessionConstraint phishingResistant(PhishingResistantEnum phishingResistant) {
        this.phishingResistant = phishingResistant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if phishing-resistant Factors are required. This property is only set for `POSSESSION` constraints.")
    @JsonProperty(value="phishingResistant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PhishingResistantEnum getPhishingResistant() {
        return this.phishingResistant;
    }

    @JsonProperty(value="phishingResistant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhishingResistant(PhishingResistantEnum phishingResistant) {
        this.phishingResistant = phishingResistant;
    }

    public PossessionConstraint userPresence(UserPresenceEnum userPresence) {
        this.userPresence = userPresence;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the user needs to approve an Okta Verify prompt or provide biometrics (meets NIST AAL2 requirements). This property is only set for `POSSESSION` constraints.")
    @JsonProperty(value="userPresence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserPresenceEnum getUserPresence() {
        return this.userPresence;
    }

    @JsonProperty(value="userPresence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserPresence(UserPresenceEnum userPresence) {
        this.userPresence = userPresence;
    }

    public PossessionConstraint userVerification(UserVerificationEnum userVerification) {
        this.userVerification = userVerification;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates the user interaction requirement (PIN or biometrics) to ensure verification of a possession factor")
    @JsonProperty(value="userVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserVerificationEnum getUserVerification() {
        return this.userVerification;
    }

    @JsonProperty(value="userVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserVerification(UserVerificationEnum userVerification) {
        this.userVerification = userVerification;
    }

    public PossessionConstraint userVerificationMethods(List<UserVerificationMethodsEnum> userVerificationMethods) {
        this.userVerificationMethods = userVerificationMethods;
        return this;
    }

    public PossessionConstraint adduserVerificationMethodsItem(UserVerificationMethodsEnum userVerificationMethodsItem) {
        if (this.userVerificationMethods == null) {
            this.userVerificationMethods = new ArrayList<UserVerificationMethodsEnum>();
        }
        this.userVerificationMethods.add(userVerificationMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates which methods can be used for user verification. `userVerificationMethods` can only be used when `userVerification` is `REQUIRED`. `BIOMETRICS` is currently the only supported method.")
    @JsonProperty(value="userVerificationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UserVerificationMethodsEnum> getUserVerificationMethods() {
        return this.userVerificationMethods;
    }

    @JsonProperty(value="userVerificationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserVerificationMethods(List<UserVerificationMethodsEnum> userVerificationMethods) {
        this.userVerificationMethods = userVerificationMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PossessionConstraint possessionConstraint = (PossessionConstraint)o;
        return Objects.equals(this.authenticationMethods, possessionConstraint.authenticationMethods) && Objects.equals(this.excludedAuthenticationMethods, possessionConstraint.excludedAuthenticationMethods) && Objects.equals(this.methods, possessionConstraint.methods) && Objects.equals(this.reauthenticateIn, possessionConstraint.reauthenticateIn) && Objects.equals(this.required, possessionConstraint.required) && Objects.equals(this.types, possessionConstraint.types) && Objects.equals((Object)this.deviceBound, (Object)possessionConstraint.deviceBound) && Objects.equals((Object)this.hardwareProtection, (Object)possessionConstraint.hardwareProtection) && Objects.equals((Object)this.phishingResistant, (Object)possessionConstraint.phishingResistant) && Objects.equals((Object)this.userPresence, (Object)possessionConstraint.userPresence) && Objects.equals((Object)this.userVerification, (Object)possessionConstraint.userVerification) && Objects.equals(this.userVerificationMethods, possessionConstraint.userVerificationMethods);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationMethods, this.excludedAuthenticationMethods, this.methods, this.reauthenticateIn, this.required, this.types, this.deviceBound, this.hardwareProtection, this.phishingResistant, this.userPresence, this.userVerification, this.userVerificationMethods});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PossessionConstraint {\n");
        sb.append("    authenticationMethods: ").append(this.toIndentedString(this.authenticationMethods)).append("\n");
        sb.append("    excludedAuthenticationMethods: ").append(this.toIndentedString(this.excludedAuthenticationMethods)).append("\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    reauthenticateIn: ").append(this.toIndentedString(this.reauthenticateIn)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("    deviceBound: ").append(this.toIndentedString((Object)this.deviceBound)).append("\n");
        sb.append("    hardwareProtection: ").append(this.toIndentedString((Object)this.hardwareProtection)).append("\n");
        sb.append("    phishingResistant: ").append(this.toIndentedString((Object)this.phishingResistant)).append("\n");
        sb.append("    userPresence: ").append(this.toIndentedString((Object)this.userPresence)).append("\n");
        sb.append("    userVerification: ").append(this.toIndentedString((Object)this.userVerification)).append("\n");
        sb.append("    userVerificationMethods: ").append(this.toIndentedString(this.userVerificationMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DeviceBoundEnum {
        OPTIONAL(String.valueOf("OPTIONAL")),
        REQUIRED(String.valueOf("REQUIRED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private DeviceBoundEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeviceBoundEnum fromValue(String value) {
            for (DeviceBoundEnum b : DeviceBoundEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum HardwareProtectionEnum {
        OPTIONAL(String.valueOf("OPTIONAL")),
        REQUIRED(String.valueOf("REQUIRED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private HardwareProtectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HardwareProtectionEnum fromValue(String value) {
            for (HardwareProtectionEnum b : HardwareProtectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum PhishingResistantEnum {
        OPTIONAL(String.valueOf("OPTIONAL")),
        REQUIRED(String.valueOf("REQUIRED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private PhishingResistantEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PhishingResistantEnum fromValue(String value) {
            for (PhishingResistantEnum b : PhishingResistantEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UserPresenceEnum {
        OPTIONAL(String.valueOf("OPTIONAL")),
        REQUIRED(String.valueOf("REQUIRED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UserPresenceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserPresenceEnum fromValue(String value) {
            for (UserPresenceEnum b : UserPresenceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UserVerificationEnum {
        OPTIONAL(String.valueOf("OPTIONAL")),
        REQUIRED(String.valueOf("REQUIRED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UserVerificationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserVerificationEnum fromValue(String value) {
            for (UserVerificationEnum b : UserVerificationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UserVerificationMethodsEnum {
        BIOMETRICS(String.valueOf("BIOMETRICS")),
        PIN(String.valueOf("PIN")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UserVerificationMethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserVerificationMethodsEnum fromValue(String value) {
            for (UserVerificationMethodsEnum b : UserVerificationMethodsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum TypesEnum {
        SECURITY_KEY(String.valueOf("SECURITY_KEY")),
        PHONE(String.valueOf("PHONE")),
        EMAIL(String.valueOf("EMAIL")),
        PASSWORD(String.valueOf("PASSWORD")),
        SECURITY_QUESTION(String.valueOf("SECURITY_QUESTION")),
        APP(String.valueOf("APP")),
        FEDERATED(String.valueOf("FEDERATED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypesEnum fromValue(String value) {
            for (TypesEnum b : TypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum MethodsEnum {
        PASSWORD(String.valueOf("PASSWORD")),
        SECURITY_QUESTION(String.valueOf("SECURITY_QUESTION")),
        SMS(String.valueOf("SMS")),
        VOICE(String.valueOf("VOICE")),
        EMAIL(String.valueOf("EMAIL")),
        PUSH(String.valueOf("PUSH")),
        SIGNED_NONCE(String.valueOf("SIGNED_NONCE")),
        OTP(String.valueOf("OTP")),
        TOTP(String.valueOf("TOTP")),
        WEBAUTHN(String.valueOf("WEBAUTHN")),
        DUO(String.valueOf("DUO")),
        IDP(String.valueOf("IDP")),
        CERT(String.valueOf("CERT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            for (MethodsEnum b : MethodsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

