/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Profile for any group that is not imported from Active Directory. Specifies the standard and custom profile properties for a group.  The `objectClass` for these groups is `okta:user_group`.")
@JsonPropertyOrder(value={"description", "name", "objectClass"})
public class OktaUserGroupProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OBJECT_CLASS = "objectClass";
    private ObjectClassEnum objectClass;

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public OktaUserGroupProfile description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="All users West of The Rockies", value="Description of the group")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public OktaUserGroupProfile name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="West Coast users", value="Name of the group")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(example="okta:user_group", value="The object class type")
    @JsonProperty(value="objectClass")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ObjectClassEnum getObjectClass() {
        return this.objectClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OktaUserGroupProfile oktaUserGroupProfile = (OktaUserGroupProfile)o;
        return Objects.equals(this.description, oktaUserGroupProfile.description) && Objects.equals(this.name, oktaUserGroupProfile.name) && Objects.equals((Object)this.objectClass, (Object)oktaUserGroupProfile.objectClass);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.name, this.objectClass, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaUserGroupProfile {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    objectClass: ").append(this.toIndentedString((Object)this.objectClass)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ObjectClassEnum {
        OKTA_USER_GROUP(String.valueOf("okta:user_group")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ObjectClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ObjectClassEnum fromValue(String value) {
            for (ObjectClassEnum b : ObjectClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

