/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Properties governing the user's session lifetime")
@JsonPropertyOrder(value={"maxSessionIdleMinutes", "maxSessionLifetimeMinutes", "usePersistentCookie"})
public class OktaSignOnPolicyRuleSignonSessionActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_MAX_SESSION_IDLE_MINUTES = "maxSessionIdleMinutes";
    private Integer maxSessionIdleMinutes = 120;
    public static final String JSON_PROPERTY_MAX_SESSION_LIFETIME_MINUTES = "maxSessionLifetimeMinutes";
    private Integer maxSessionLifetimeMinutes = 0;
    public static final String JSON_PROPERTY_USE_PERSISTENT_COOKIE = "usePersistentCookie";
    private Boolean usePersistentCookie = false;

    public OktaSignOnPolicyRuleSignonSessionActions maxSessionIdleMinutes(Integer maxSessionIdleMinutes) {
        this.maxSessionIdleMinutes = maxSessionIdleMinutes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum number of minutes that a user session can be idle before the session is ended")
    @JsonProperty(value="maxSessionIdleMinutes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxSessionIdleMinutes() {
        return this.maxSessionIdleMinutes;
    }

    @JsonProperty(value="maxSessionIdleMinutes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxSessionIdleMinutes(Integer maxSessionIdleMinutes) {
        this.maxSessionIdleMinutes = maxSessionIdleMinutes;
    }

    public OktaSignOnPolicyRuleSignonSessionActions maxSessionLifetimeMinutes(Integer maxSessionLifetimeMinutes) {
        this.maxSessionLifetimeMinutes = maxSessionLifetimeMinutes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum number of minutes (from when the user signs in) that a user's session is active. Set this to force users to sign in again after the number of specified minutes. Disable by setting to `0`.")
    @JsonProperty(value="maxSessionLifetimeMinutes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxSessionLifetimeMinutes() {
        return this.maxSessionLifetimeMinutes;
    }

    @JsonProperty(value="maxSessionLifetimeMinutes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxSessionLifetimeMinutes(Integer maxSessionLifetimeMinutes) {
        this.maxSessionLifetimeMinutes = maxSessionLifetimeMinutes;
    }

    public OktaSignOnPolicyRuleSignonSessionActions usePersistentCookie(Boolean usePersistentCookie) {
        this.usePersistentCookie = usePersistentCookie;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `false`, user session cookies only last the length of a browser session. If set to `true`, user session cookies last across browser sessions. This setting doesn't impact administrators who can never have persistent session cookies. This property is read-only for the default rule of the default global session policy.")
    @JsonProperty(value="usePersistentCookie")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUsePersistentCookie() {
        return this.usePersistentCookie;
    }

    @JsonProperty(value="usePersistentCookie")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsePersistentCookie(Boolean usePersistentCookie) {
        this.usePersistentCookie = usePersistentCookie;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OktaSignOnPolicyRuleSignonSessionActions oktaSignOnPolicyRuleSignonSessionActions = (OktaSignOnPolicyRuleSignonSessionActions)o;
        return Objects.equals(this.maxSessionIdleMinutes, oktaSignOnPolicyRuleSignonSessionActions.maxSessionIdleMinutes) && Objects.equals(this.maxSessionLifetimeMinutes, oktaSignOnPolicyRuleSignonSessionActions.maxSessionLifetimeMinutes) && Objects.equals(this.usePersistentCookie, oktaSignOnPolicyRuleSignonSessionActions.usePersistentCookie);
    }

    public int hashCode() {
        return Objects.hash(this.maxSessionIdleMinutes, this.maxSessionLifetimeMinutes, this.usePersistentCookie);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaSignOnPolicyRuleSignonSessionActions {\n");
        sb.append("    maxSessionIdleMinutes: ").append(this.toIndentedString(this.maxSessionIdleMinutes)).append("\n");
        sb.append("    maxSessionLifetimeMinutes: ").append(this.toIndentedString(this.maxSessionLifetimeMinutes)).append("\n");
        sb.append("    usePersistentCookie: ").append(this.toIndentedString(this.usePersistentCookie)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

