/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Advanced settings for the OpenID Connect protocol")
@JsonPropertyOrder(value={"participateSlo", "sendApplicationContext"})
public class OidcSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PARTICIPATE_SLO = "participateSlo";
    private Boolean participateSlo;
    public static final String JSON_PROPERTY_SEND_APPLICATION_CONTEXT = "sendApplicationContext";
    private Boolean sendApplicationContext = false;

    public OidcSettings participateSlo(Boolean participateSlo) {
        this.participateSlo = participateSlo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set to `true` to have Okta send a logout request to the upstream IdP when a user signs out of Okta or a downstream app.")
    @JsonProperty(value="participateSlo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getParticipateSlo() {
        return this.participateSlo;
    }

    @JsonProperty(value="participateSlo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParticipateSlo(Boolean participateSlo) {
        this.participateSlo = participateSlo;
    }

    public OidcSettings sendApplicationContext(Boolean sendApplicationContext) {
        this.sendApplicationContext = sendApplicationContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines if the IdP should send the application context as `OktaAppInstanceId` and `OktaAppName` params in the request")
    @JsonProperty(value="sendApplicationContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendApplicationContext() {
        return this.sendApplicationContext;
    }

    @JsonProperty(value="sendApplicationContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendApplicationContext(Boolean sendApplicationContext) {
        this.sendApplicationContext = sendApplicationContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OidcSettings oidcSettings = (OidcSettings)o;
        return Objects.equals(this.participateSlo, oidcSettings.participateSlo) && Objects.equals(this.sendApplicationContext, oidcSettings.sendApplicationContext);
    }

    public int hashCode() {
        return Objects.hash(this.participateSlo, this.sendApplicationContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OidcSettings {\n");
        sb.append("    participateSlo: ").append(this.toIndentedString(this.participateSlo)).append("\n");
        sb.append("    sendApplicationContext: ").append(this.toIndentedString(this.sendApplicationContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

