/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuthResourceServerKeyLinks;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"created", "e", "id", "kid", "kty", "lastUpdated", "n", "status", "use", "_links"})
public class OAuth2ResourceServerJsonWebKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_KID = "kid";
    private JsonNullable<String> kid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;
    public static final String JSON_PROPERTY_N = "n";
    private String n;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_USE = "use";
    private String use;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuthResourceServerKeyLinks links;

    @Nullable
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", value="Timestamp when the JSON Web Key was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreated() {
        return this.created;
    }

    public OAuth2ResourceServerJsonWebKey e(String e) {
        this.e = e;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AQAB", value="RSA key value (exponent) for key binding")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getE() {
        return this.e;
    }

    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setE(String e) {
        this.e = e;
    }

    @Nullable
    @ApiModelProperty(example="apk2f4zrZbs8nUa7p0g4", value="The unique ID of the JSON Web Key")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public OAuth2ResourceServerJsonWebKey kid(String kid) {
        this.kid = JsonNullable.of((Object)kid);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SIMcCQNY3uwXoW3y0vf6VxiBb5n9pf8L2fK8d-FIbm4", value="Unique identifier of the JSON Web Key in the Custom Authorization Server's Public JWKS")
    @JsonIgnore
    public String getKid() {
        return (String)this.kid.orElse(null);
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getKid_JsonNullable() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    public void setKid_JsonNullable(JsonNullable<String> kid) {
        this.kid = kid;
    }

    public void setKid(String kid) {
        this.kid = JsonNullable.of((Object)kid);
    }

    public OAuth2ResourceServerJsonWebKey kty(String kty) {
        this.kty = kty;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RSA", value="Cryptographic algorithm family for the certificate's key pair")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKty(String kty) {
        this.kty = kty;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", value="Timestamp when the JSON Web Key was updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public OAuth2ResourceServerJsonWebKey n(String n) {
        this.n = n;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mkC6yAJVvFwUlmM9gKjb2d-YK5qHFt-mXSsbjWKKs4EfNm-BoQeeovBZtSACyaqLc8IYFTPEURFcbDQ9DkAL04uUIRD2gaHYY7uK0jsluEaXGq2RAIsmzAwNTzkiDw4q9pDL_q7n0f_SDt1TsMaMQayB6bU5jWsmqcWJ8MCRJ1aJMjZ16un5UVx51IIeCbe4QRDxEXGAvYNczsBoZxspDt28esSpq5W0dBFxcyGVudyl54Er3FzAguhgfMVjH-bUec9j2Tl40qDTktrYgYfxz9pfjm01Hl4WYP1YQxeETpSL7cQ5Ihz4jGDtHUEOcZ4GfJrPzrGpUrak8Qp5xcwCqQ", value="RSA key value (modulus) for key binding")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    public OAuth2ResourceServerJsonWebKey status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="The status of the encryption key. You can use only an `ACTIVE` key to encrypt tokens issued by the authorization server.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OAuth2ResourceServerJsonWebKey use(String use) {
        this.use = use;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="enc", value="Acceptable use of the JSON Web Key")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUse(String use) {
        this.use = use;
    }

    public OAuth2ResourceServerJsonWebKey links(OAuthResourceServerKeyLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuthResourceServerKeyLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuthResourceServerKeyLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ResourceServerJsonWebKey oauth2ResourceServerJsonWebKey = (OAuth2ResourceServerJsonWebKey)o;
        return Objects.equals(this.created, oauth2ResourceServerJsonWebKey.created) && Objects.equals(this.e, oauth2ResourceServerJsonWebKey.e) && Objects.equals(this.id, oauth2ResourceServerJsonWebKey.id) && OAuth2ResourceServerJsonWebKey.equalsNullable(this.kid, oauth2ResourceServerJsonWebKey.kid) && Objects.equals(this.kty, oauth2ResourceServerJsonWebKey.kty) && Objects.equals(this.lastUpdated, oauth2ResourceServerJsonWebKey.lastUpdated) && Objects.equals(this.n, oauth2ResourceServerJsonWebKey.n) && Objects.equals((Object)this.status, (Object)oauth2ResourceServerJsonWebKey.status) && Objects.equals(this.use, oauth2ResourceServerJsonWebKey.use) && Objects.equals(this.links, oauth2ResourceServerJsonWebKey.links);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.e, this.id, OAuth2ResourceServerJsonWebKey.hashCodeNullable(this.kid), this.kty, this.lastUpdated, this.n, this.status, this.use, this.links});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ResourceServerJsonWebKey {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString(this.kty)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    use: ").append(this.toIndentedString(this.use)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

