/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.OAuth2ClientJsonSigningKeyResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="An RSA signing key")
@JsonPropertyOrder(value={"e", "n"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="kty", visible=true, defaultImpl=OAuth2ClientJsonWebKeyRsaResponse.class)
public class OAuth2ClientJsonWebKeyRsaResponse
extends OAuth2ClientJsonSigningKeyResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_N = "n";
    private String n;

    public OAuth2ClientJsonWebKeyRsaResponse e(String e) {
        this.e = e;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="AQAB", required=true, value="RSA key value (exponent) for key binding")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getE() {
        return this.e;
    }

    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setE(String e) {
        this.e = e;
    }

    public OAuth2ClientJsonWebKeyRsaResponse n(String n) {
        this.n = n;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="mkC6yAJVvFwUlmM9gKjb2d-YK5qHFt-mXSsbjWKKs4EfNm-BoQeeovBZtSACyaqLc8IYFTPEURFcbDQ9DkAL04uUIRD2gaHYY7uK0jsluEaXGq2RAIsmzAwNTzkiDw4q9pDL_q7n0f_SDt1TsMaMQayB6bU5jWsmqcWJ8MCRJ1aJMjZ16un5UVx51IIeCbe4QRDxEXGAvYNczsBoZxspDt28esSpq5W0dBFxcyGVudyl54Er3FzAguhgfMVjH-bUec9j2Tl40qDTktrYgYfxz9pfjm01Hl4WYP1YQxeETpSL7cQ5Ihz4jGDtHUEOcZ4GfJrPzrGpUrak8Qp5xcwCqQ", required=true, value="RSA key value (modulus) for key binding")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setN(String n) {
        this.n = n;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientJsonWebKeyRsaResponse oauth2ClientJsonWebKeyRsaResponse = (OAuth2ClientJsonWebKeyRsaResponse)o;
        return Objects.equals(this.e, oauth2ClientJsonWebKeyRsaResponse.e) && Objects.equals(this.n, oauth2ClientJsonWebKeyRsaResponse.n);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.e, this.n, super.hashCode());
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientJsonWebKeyRsaResponse {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

