/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuth2ClientJsonSigningKeyResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="An EC signing key")
@JsonPropertyOrder(value={"x", "y", "crv"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="kty", visible=true, defaultImpl=OAuth2ClientJsonWebKeyECResponse.class)
public class OAuth2ClientJsonWebKeyECResponse
extends OAuth2ClientJsonSigningKeyResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_X = "x";
    private String x;
    public static final String JSON_PROPERTY_Y = "y";
    private String y;
    public static final String JSON_PROPERTY_CRV = "crv";
    private CrvEnum crv;

    public OAuth2ClientJsonWebKeyECResponse x(String x) {
        this.x = x;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The public x coordinate for the elliptic curve point")
    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getX() {
        return this.x;
    }

    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setX(String x) {
        this.x = x;
    }

    public OAuth2ClientJsonWebKeyECResponse y(String y) {
        this.y = y;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The public y coordinate for the elliptic curve point")
    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getY() {
        return this.y;
    }

    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setY(String y) {
        this.y = y;
    }

    public OAuth2ClientJsonWebKeyECResponse crv(CrvEnum crv) {
        this.crv = crv;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="P-256", required=true, value="The cryptographic curve used with the key")
    @JsonProperty(value="crv")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CrvEnum getCrv() {
        return this.crv;
    }

    @JsonProperty(value="crv")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCrv(CrvEnum crv) {
        this.crv = crv;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientJsonWebKeyECResponse oauth2ClientJsonWebKeyECResponse = (OAuth2ClientJsonWebKeyECResponse)o;
        return Objects.equals(this.x, oauth2ClientJsonWebKeyECResponse.x) && Objects.equals(this.y, oauth2ClientJsonWebKeyECResponse.y) && Objects.equals((Object)this.crv, (Object)oauth2ClientJsonWebKeyECResponse.crv);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.x, this.y, this.crv, super.hashCode()});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientJsonWebKeyECResponse {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("    crv: ").append(this.toIndentedString((Object)this.crv)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CrvEnum {
        P_256(String.valueOf("P-256")),
        P_384(String.valueOf("P-384")),
        P_521(String.valueOf("P-521")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private CrvEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CrvEnum fromValue(String value) {
            for (CrvEnum b : CrvEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

