/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="<x-lifecycle-container><x-lifecycle class=\"oie\"></x-lifecycle></x-lifecycle-container>Controls how often the post-authentication prompt is presented to users")
@JsonPropertyOrder(value={"postAuth", "postAuthPromptFrequency"})
public class KeepMeSignedIn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_POST_AUTH = "postAuth";
    private PostAuthEnum postAuth;
    public static final String JSON_PROPERTY_POST_AUTH_PROMPT_FREQUENCY = "postAuthPromptFrequency";
    private String postAuthPromptFrequency;

    public KeepMeSignedIn postAuth(PostAuthEnum postAuth) {
        this.postAuth = postAuth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the post-authentication [Keep Me Signed In (KMSI)](https://help.okta.com/oie/en-us/content/topics/security/stay-signed-in.htm) flow is allowed")
    @JsonProperty(value="postAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PostAuthEnum getPostAuth() {
        return this.postAuth;
    }

    @JsonProperty(value="postAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostAuth(PostAuthEnum postAuth) {
        this.postAuth = postAuth;
    }

    public KeepMeSignedIn postAuthPromptFrequency(String postAuthPromptFrequency) {
        this.postAuthPromptFrequency = postAuthPromptFrequency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A time duration specified as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    @JsonProperty(value="postAuthPromptFrequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostAuthPromptFrequency() {
        return this.postAuthPromptFrequency;
    }

    @JsonProperty(value="postAuthPromptFrequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostAuthPromptFrequency(String postAuthPromptFrequency) {
        this.postAuthPromptFrequency = postAuthPromptFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeepMeSignedIn keepMeSignedIn = (KeepMeSignedIn)o;
        return Objects.equals((Object)this.postAuth, (Object)keepMeSignedIn.postAuth) && Objects.equals(this.postAuthPromptFrequency, keepMeSignedIn.postAuthPromptFrequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.postAuth, this.postAuthPromptFrequency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeepMeSignedIn {\n");
        sb.append("    postAuth: ").append(this.toIndentedString((Object)this.postAuth)).append("\n");
        sb.append("    postAuthPromptFrequency: ").append(this.toIndentedString(this.postAuthPromptFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PostAuthEnum {
        ALLOWED(String.valueOf("ALLOWED")),
        NOT_ALLOWED(String.valueOf("NOT_ALLOWED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private PostAuthEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PostAuthEnum fromValue(String value) {
            for (PostAuthEnum b : PostAuthEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

