/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.WebAuthnCredRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Yubico transport key in the form of a JSON Web Token (JWK), used to encrypt our fulfillment request to Yubico. The currently agreed protocol uses P-384.")
@JsonPropertyOrder(value={"credRequests", "fulfillmentProvider", "pinRequestJwe", "userId"})
public class EnrollmentInitializationResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CRED_REQUESTS = "credRequests";
    private List<WebAuthnCredRequest> credRequests = null;
    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;
    public static final String JSON_PROPERTY_PIN_REQUEST_JWE = "pinRequestJwe";
    private String pinRequestJwe;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public EnrollmentInitializationResponse credRequests(List<WebAuthnCredRequest> credRequests) {
        this.credRequests = credRequests;
        return this;
    }

    public EnrollmentInitializationResponse addcredRequestsItem(WebAuthnCredRequest credRequestsItem) {
        if (this.credRequests == null) {
            this.credRequests = new ArrayList<WebAuthnCredRequest>();
        }
        this.credRequests.add(credRequestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of credential requests for the fulfillment provider")
    @JsonProperty(value="credRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WebAuthnCredRequest> getCredRequests() {
        return this.credRequests;
    }

    @JsonProperty(value="credRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredRequests(List<WebAuthnCredRequest> credRequests) {
        this.credRequests = credRequests;
    }

    public EnrollmentInitializationResponse fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the fulfillment provider for the WebAuthn preregistration factor")
    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FulfillmentProviderEnum getFulfillmentProvider() {
        return this.fulfillmentProvider;
    }

    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public EnrollmentInitializationResponse pinRequestJwe(String pinRequestJwe) {
        this.pinRequestJwe = pinRequestJwe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Encrypted JWE of PIN request for the fulfillment provider")
    @JsonProperty(value="pinRequestJwe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPinRequestJwe() {
        return this.pinRequestJwe;
    }

    @JsonProperty(value="pinRequestJwe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPinRequestJwe(String pinRequestJwe) {
        this.pinRequestJwe = pinRequestJwe;
    }

    public EnrollmentInitializationResponse userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of an existing Okta user")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrollmentInitializationResponse enrollmentInitializationResponse = (EnrollmentInitializationResponse)o;
        return Objects.equals(this.credRequests, enrollmentInitializationResponse.credRequests) && Objects.equals((Object)this.fulfillmentProvider, (Object)enrollmentInitializationResponse.fulfillmentProvider) && Objects.equals(this.pinRequestJwe, enrollmentInitializationResponse.pinRequestJwe) && Objects.equals(this.userId, enrollmentInitializationResponse.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credRequests, this.fulfillmentProvider, this.pinRequestJwe, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrollmentInitializationResponse {\n");
        sb.append("    credRequests: ").append(this.toIndentedString(this.credRequests)).append("\n");
        sb.append("    fulfillmentProvider: ").append(this.toIndentedString((Object)this.fulfillmentProvider)).append("\n");
        sb.append("    pinRequestJwe: ").append(this.toIndentedString(this.pinRequestJwe)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FulfillmentProviderEnum {
        YUBICO(String.valueOf("yubico")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

