/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgCreationAdmin;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"admin", "created", "edition", "id", "lastUpdated", "name", "settings", "status", "subdomain", "token", "tokenType", "website", "_links"})
public class ChildOrg
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ADMIN = "admin";
    private OrgCreationAdmin admin;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_EDITION = "edition";
    private EditionEnum edition;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private Map<String, Object> settings = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_SUBDOMAIN = "subdomain";
    private String subdomain;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_TOKEN_TYPE = "tokenType";
    private TokenTypeEnum tokenType;
    public static final String JSON_PROPERTY_WEBSITE = "website";
    private String website;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private Map<String, Object> links = null;

    public ChildOrg admin(OrgCreationAdmin admin) {
        this.admin = admin;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="admin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OrgCreationAdmin getAdmin() {
        return this.admin;
    }

    @JsonProperty(value="admin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdmin(OrgCreationAdmin admin) {
        this.admin = admin;
    }

    @Nullable
    @ApiModelProperty(example="2022-08-25T00:05Z", value="Timestamp when the org was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public ChildOrg edition(EditionEnum edition) {
        this.edition = edition;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="SKU", required=true, value="Edition for the org. `SKU` is the only supported value.")
    @JsonProperty(value="edition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EditionEnum getEdition() {
        return this.edition;
    }

    @JsonProperty(value="edition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEdition(EditionEnum edition) {
        this.edition = edition;
    }

    @Nullable
    @ApiModelProperty(example="00o1n8sbwArJ7OQRw406", value="Org ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2022-08-25T00:05Z", value="Timestamp when the org was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public ChildOrg name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="My Child Org 1", required=true, value="Unique name of the org. This name appears in the HTML `<title>` tag of the new org sign-in page. Only less than 4-width UTF-8 encoded characters are allowed.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(value="Settings associated with the created org")
    @JsonProperty(value="settings")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    @Nullable
    @ApiModelProperty(value="Status of the org. `ACTIVE` is returned after the org is created.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public ChildOrg subdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="my-child-org-1", required=true, value="Subdomain of the org. Must be unique and include no spaces.")
    @JsonProperty(value="subdomain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSubdomain() {
        return this.subdomain;
    }

    @JsonProperty(value="subdomain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }

    @Nullable
    @ApiModelProperty(value="API token associated with the child org super admin account. Use this API token to provision resources (such as policies, apps, and groups) on the newly created child org. This token is revoked if the super admin account is deactivated. > **Note:** If this API token expires, sign in to the Admin Console as the super admin user and create a new API token. See [Create an API token](https://developer.okta.com/docs/guides/create-an-api-token/).")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToken() {
        return this.token;
    }

    @Nullable
    @ApiModelProperty(example="SSWS", value="Type of returned `token`. See [Okta API tokens](https://developer.okta.com/docs/guides/create-an-api-token/main/#okta-api-tokens).")
    @JsonProperty(value="tokenType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public ChildOrg website(String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.okta.com", value="Default website for the org")
    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebsite() {
        return this.website;
    }

    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebsite(String website) {
        this.website = website;
    }

    @Nullable
    @ApiModelProperty(value="Specifies available link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
    @JsonProperty(value="_links")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChildOrg childOrg = (ChildOrg)o;
        return Objects.equals(this.admin, childOrg.admin) && Objects.equals(this.created, childOrg.created) && Objects.equals((Object)this.edition, (Object)childOrg.edition) && Objects.equals(this.id, childOrg.id) && Objects.equals(this.lastUpdated, childOrg.lastUpdated) && Objects.equals(this.name, childOrg.name) && Objects.equals(this.settings, childOrg.settings) && Objects.equals((Object)this.status, (Object)childOrg.status) && Objects.equals(this.subdomain, childOrg.subdomain) && Objects.equals(this.token, childOrg.token) && Objects.equals((Object)this.tokenType, (Object)childOrg.tokenType) && Objects.equals(this.website, childOrg.website) && Objects.equals(this.links, childOrg.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.admin, this.created, this.edition, this.id, this.lastUpdated, this.name, this.settings, this.status, this.subdomain, this.token, this.tokenType, this.website, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChildOrg {\n");
        sb.append("    admin: ").append(this.toIndentedString(this.admin)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    edition: ").append(this.toIndentedString((Object)this.edition)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subdomain: ").append(this.toIndentedString(this.subdomain)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EditionEnum {
        SKU(String.valueOf("SKU")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private EditionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EditionEnum fromValue(String value) {
            for (EditionEnum b : EditionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum TokenTypeEnum {
        SSWS(String.valueOf("SSWS")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

