/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CaepCredentialChangeEventReasonAdmin;
import com.okta.sdk.resource.model.CaepCredentialChangeEventReasonUser;
import com.okta.sdk.resource.model.SsfTransmitterSecurityEventSubject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The credential was created, changed, revoked or deleted")
@JsonPropertyOrder(value={"change_type", "credential_type", "event_timestamp", "fido2_aaguid", "friendly_name", "initiating_entity", "reason_admin", "reason_user", "subject"})
public class CaepCredentialChangeEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CHANGE_TYPE = "change_type";
    private ChangeTypeEnum changeType;
    public static final String JSON_PROPERTY_CREDENTIAL_TYPE = "credential_type";
    private CredentialTypeEnum credentialType;
    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;
    public static final String JSON_PROPERTY_FIDO2_AAGUID = "fido2_aaguid";
    private String fido2Aaguid;
    public static final String JSON_PROPERTY_FRIENDLY_NAME = "friendly_name";
    private String friendlyName;
    public static final String JSON_PROPERTY_INITIATING_ENTITY = "initiating_entity";
    private InitiatingEntityEnum initiatingEntity;
    public static final String JSON_PROPERTY_REASON_ADMIN = "reason_admin";
    private CaepCredentialChangeEventReasonAdmin reasonAdmin;
    public static final String JSON_PROPERTY_REASON_USER = "reason_user";
    private CaepCredentialChangeEventReasonUser reasonUser;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SsfTransmitterSecurityEventSubject subject;

    public CaepCredentialChangeEvent changeType(ChangeTypeEnum changeType) {
        this.changeType = changeType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of action done towards the credential")
    @JsonProperty(value="change_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ChangeTypeEnum getChangeType() {
        return this.changeType;
    }

    @JsonProperty(value="change_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChangeType(ChangeTypeEnum changeType) {
        this.changeType = changeType;
    }

    public CaepCredentialChangeEvent credentialType(CredentialTypeEnum credentialType) {
        this.credentialType = credentialType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The credential type of the changed credential. It will one of the supported enum values or any other credential type supported mutually by the Transmitter and the Receiver.")
    @JsonProperty(value="credential_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CredentialTypeEnum getCredentialType() {
        return this.credentialType;
    }

    @JsonProperty(value="credential_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCredentialType(CredentialTypeEnum credentialType) {
        this.credentialType = credentialType;
    }

    public CaepCredentialChangeEvent eventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1702448550", value="The time of the event (UNIX timestamp)")
    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEventTimestamp() {
        return this.eventTimestamp;
    }

    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public CaepCredentialChangeEvent fido2Aaguid(String fido2Aaguid) {
        this.fido2Aaguid = fido2Aaguid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="accced6a-63f5-490a-9eea-e59bc1896cfc", value="FIDO2 Authenticator Attestation GUID")
    @JsonProperty(value="fido2_aaguid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFido2Aaguid() {
        return this.fido2Aaguid;
    }

    @JsonProperty(value="fido2_aaguid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFido2Aaguid(String fido2Aaguid) {
        this.fido2Aaguid = fido2Aaguid;
    }

    public CaepCredentialChangeEvent friendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="John's FIDO authenticator", value="Credential friendly name")
    @JsonProperty(value="friendly_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @JsonProperty(value="friendly_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public CaepCredentialChangeEvent initiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The entity that initiated the event")
    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InitiatingEntityEnum getInitiatingEntity() {
        return this.initiatingEntity;
    }

    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
    }

    public CaepCredentialChangeEvent reasonAdmin(CaepCredentialChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepCredentialChangeEventReasonAdmin getReasonAdmin() {
        return this.reasonAdmin;
    }

    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonAdmin(CaepCredentialChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
    }

    public CaepCredentialChangeEvent reasonUser(CaepCredentialChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepCredentialChangeEventReasonUser getReasonUser() {
        return this.reasonUser;
    }

    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonUser(CaepCredentialChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
    }

    public CaepCredentialChangeEvent subject(SsfTransmitterSecurityEventSubject subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SsfTransmitterSecurityEventSubject getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(SsfTransmitterSecurityEventSubject subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaepCredentialChangeEvent caepCredentialChangeEvent = (CaepCredentialChangeEvent)o;
        return Objects.equals((Object)this.changeType, (Object)caepCredentialChangeEvent.changeType) && Objects.equals((Object)this.credentialType, (Object)caepCredentialChangeEvent.credentialType) && Objects.equals(this.eventTimestamp, caepCredentialChangeEvent.eventTimestamp) && Objects.equals(this.fido2Aaguid, caepCredentialChangeEvent.fido2Aaguid) && Objects.equals(this.friendlyName, caepCredentialChangeEvent.friendlyName) && Objects.equals((Object)this.initiatingEntity, (Object)caepCredentialChangeEvent.initiatingEntity) && Objects.equals(this.reasonAdmin, caepCredentialChangeEvent.reasonAdmin) && Objects.equals(this.reasonUser, caepCredentialChangeEvent.reasonUser) && Objects.equals(this.subject, caepCredentialChangeEvent.subject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeType, this.credentialType, this.eventTimestamp, this.fido2Aaguid, this.friendlyName, this.initiatingEntity, this.reasonAdmin, this.reasonUser, this.subject});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaepCredentialChangeEvent {\n");
        sb.append("    changeType: ").append(this.toIndentedString((Object)this.changeType)).append("\n");
        sb.append("    credentialType: ").append(this.toIndentedString((Object)this.credentialType)).append("\n");
        sb.append("    eventTimestamp: ").append(this.toIndentedString(this.eventTimestamp)).append("\n");
        sb.append("    fido2Aaguid: ").append(this.toIndentedString(this.fido2Aaguid)).append("\n");
        sb.append("    friendlyName: ").append(this.toIndentedString(this.friendlyName)).append("\n");
        sb.append("    initiatingEntity: ").append(this.toIndentedString((Object)this.initiatingEntity)).append("\n");
        sb.append("    reasonAdmin: ").append(this.toIndentedString(this.reasonAdmin)).append("\n");
        sb.append("    reasonUser: ").append(this.toIndentedString(this.reasonUser)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ChangeTypeEnum {
        CREATE(String.valueOf("create")),
        REVOKE(String.valueOf("revoke")),
        UPDATE(String.valueOf("update")),
        DELETE(String.valueOf("delete")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ChangeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChangeTypeEnum fromValue(String value) {
            for (ChangeTypeEnum b : ChangeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum CredentialTypeEnum {
        PASSWORD(String.valueOf("password")),
        PIN(String.valueOf("pin")),
        X509(String.valueOf("x509")),
        FIDO2_PLATFORM(String.valueOf("fido2-platform")),
        FIDO2_ROAMING(String.valueOf("fido2-roaming")),
        FIDO_U2F(String.valueOf("fido-u2f")),
        VERIFIABLE_CREDENTIAL(String.valueOf("verifiable-credential")),
        PHONE_VOICE(String.valueOf("phone-voice")),
        PHONE_SMS(String.valueOf("phone-sms")),
        APP(String.valueOf("app")),
        SECURITY_QUESTION(String.valueOf("SECURITY_QUESTION")),
        SOFT_TOKEN(String.valueOf("SOFT_TOKEN")),
        OKTA_SOFT_TOKEN(String.valueOf("OKTA_SOFT_TOKEN")),
        VIP_FACTOR(String.valueOf("VIP_FACTOR")),
        EMAIL_FACTOR(String.valueOf("EMAIL_FACTOR")),
        SECUREID_FACTOR(String.valueOf("SECUREID_FACTOR")),
        DUO_SECURITY(String.valueOf("DUO_SECURITY")),
        OKTA_VERIFY_PUSH(String.valueOf("OKTA_VERIFY_PUSH")),
        YUBIKEY_OTP_FACTOR(String.valueOf("YUBIKEY_OTP_FACTOR")),
        FIDO_WEBAUTHN(String.valueOf("FIDO_WEBAUTHN")),
        CUSTOM_APP_PUSH(String.valueOf("CUSTOM_APP_PUSH")),
        CLAIMS_AS_FACTOR(String.valueOf("CLAIMS_AS_FACTOR")),
        HOTP_FACTOR(String.valueOf("HOTP_FACTOR")),
        SIGNED_NONCE(String.valueOf("SIGNED_NONCE")),
        ALL_FACTORS(String.valueOf("ALL_FACTORS")),
        TOTP(String.valueOf("TOTP")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private CredentialTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CredentialTypeEnum fromValue(String value) {
            for (CredentialTypeEnum b : CredentialTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum InitiatingEntityEnum {
        ADMIN(String.valueOf("admin")),
        USER(String.valueOf("user")),
        POLICY(String.valueOf("policy")),
        SYSTEM(String.valueOf("system")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private InitiatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InitiatingEntityEnum fromValue(String value) {
            for (InitiatingEntityEnum b : InitiatingEntityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

