/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the authenticator specific parameters")
@JsonPropertyOrder(value={"multiUse", "ttl"})
public class AuthenticatorProfileTacRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_MULTI_USE = "multiUse";
    private Boolean multiUse;
    public static final String JSON_PROPERTY_TTL = "ttl";
    private String ttl;

    public AuthenticatorProfileTacRequest multiUse(Boolean multiUse) {
        this.multiUse = multiUse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines whether the enrollment can be used more than once. To enable multi-use, the org-level authenticator\u2019s configuration must allow multi-use.")
    @JsonProperty(value="multiUse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMultiUse() {
        return this.multiUse;
    }

    @JsonProperty(value="multiUse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultiUse(Boolean multiUse) {
        this.multiUse = multiUse;
    }

    public AuthenticatorProfileTacRequest ttl(String ttl) {
        this.ttl = ttl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time-to-live (TTL) in minutes.  Specifies how long the TAC enrollment is valid after it's created and activated. The configured value must be between 10 minutes (`10`) and 10 days (`14400`), inclusive. The actual allowed range depends on the org-level authenticator configuration.")
    @JsonProperty(value="ttl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="ttl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorProfileTacRequest authenticatorProfileTacRequest = (AuthenticatorProfileTacRequest)o;
        return Objects.equals(this.multiUse, authenticatorProfileTacRequest.multiUse) && Objects.equals(this.ttl, authenticatorProfileTacRequest.ttl);
    }

    public int hashCode() {
        return Objects.hash(this.multiUse, this.ttl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorProfileTacRequest {\n");
        sb.append("    multiUse: ").append(this.toIndentedString(this.multiUse)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

