/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentPolicyAuthenticatorSettings;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentPolicySettingsType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies the policy level settings  > **Note:** In Identity Engine, the Multifactor (MFA) Enrollment policy name has changed to authenticator enrollment policy. The policy type of `MFA_ENROLL` remains unchanged. However, the `settings` data is updated for authenticators. Policy `settings` are included only for those authenticators that are enabled.")
@JsonPropertyOrder(value={"authenticators", "type"})
public class AuthenticatorEnrollmentPolicySettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHENTICATORS = "authenticators";
    private List<AuthenticatorEnrollmentPolicyAuthenticatorSettings> authenticators = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AuthenticatorEnrollmentPolicySettingsType type = AuthenticatorEnrollmentPolicySettingsType.FACTORS;

    public AuthenticatorEnrollmentPolicySettings authenticators(List<AuthenticatorEnrollmentPolicyAuthenticatorSettings> authenticators) {
        this.authenticators = authenticators;
        return this;
    }

    public AuthenticatorEnrollmentPolicySettings addauthenticatorsItem(AuthenticatorEnrollmentPolicyAuthenticatorSettings authenticatorsItem) {
        if (this.authenticators == null) {
            this.authenticators = new ArrayList<AuthenticatorEnrollmentPolicyAuthenticatorSettings>();
        }
        this.authenticators.add(authenticatorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of authenticator policy settings  <x-lifecycle class=\"oie\"></x-lifecycle> For orgs with the Authenticator enrollment policy feature enabled, the new default authenticator enrollment policy created by Okta contains the `authenticators` property in the policy settings. Existing default authenticator enrollment policies from a migrated Classic Engine org remain unchanged. The policies still use the `factors` property in their settings. The `authenticators` parameter allows you to configure all available authenticators, including authentication and recovery. The `factors` parameter only allows you to configure multifactor authentication. ")
    @JsonProperty(value="authenticators")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthenticatorEnrollmentPolicyAuthenticatorSettings> getAuthenticators() {
        return this.authenticators;
    }

    @JsonProperty(value="authenticators")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticators(List<AuthenticatorEnrollmentPolicyAuthenticatorSettings> authenticators) {
        this.authenticators = authenticators;
    }

    public AuthenticatorEnrollmentPolicySettings type(AuthenticatorEnrollmentPolicySettingsType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthenticatorEnrollmentPolicySettingsType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(AuthenticatorEnrollmentPolicySettingsType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorEnrollmentPolicySettings authenticatorEnrollmentPolicySettings = (AuthenticatorEnrollmentPolicySettings)o;
        return Objects.equals(this.authenticators, authenticatorEnrollmentPolicySettings.authenticators) && Objects.equals((Object)this.type, (Object)authenticatorEnrollmentPolicySettings.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticators, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorEnrollmentPolicySettings {\n");
        sb.append("    authenticators: ").append(this.toIndentedString(this.authenticators)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

