/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.AccessPolicyConstraints;
import com.okta.sdk.resource.model.AssuranceMethodFactorMode;
import com.okta.sdk.resource.model.VerificationMethod;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"constraints", "factorMode", "inactivityPeriod", "reauthenticateIn"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=AssuranceMethod.class)
public class AssuranceMethod
extends VerificationMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CONSTRAINTS = "constraints";
    private List<AccessPolicyConstraints> constraints = null;
    public static final String JSON_PROPERTY_FACTOR_MODE = "factorMode";
    private AssuranceMethodFactorMode factorMode;
    public static final String JSON_PROPERTY_INACTIVITY_PERIOD = "inactivityPeriod";
    private String inactivityPeriod;
    public static final String JSON_PROPERTY_REAUTHENTICATE_IN = "reauthenticateIn";
    private String reauthenticateIn;

    public AssuranceMethod constraints(List<AccessPolicyConstraints> constraints) {
        this.constraints = constraints;
        return this;
    }

    public AssuranceMethod addconstraintsItem(AccessPolicyConstraints constraintsItem) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<AccessPolicyConstraints>();
        }
        this.constraints.add(constraintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies constraints for the authenticator. Constraints are logically evaluated such that only one constraint object needs to be satisfied. But, within a constraint object, each constraint property must be satisfied.")
    @JsonProperty(value="constraints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AccessPolicyConstraints> getConstraints() {
        return this.constraints;
    }

    @JsonProperty(value="constraints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConstraints(List<AccessPolicyConstraints> constraints) {
        this.constraints = constraints;
    }

    public AssuranceMethod factorMode(AssuranceMethodFactorMode factorMode) {
        this.factorMode = factorMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="factorMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AssuranceMethodFactorMode getFactorMode() {
        return this.factorMode;
    }

    @JsonProperty(value="factorMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactorMode(AssuranceMethodFactorMode factorMode) {
        this.factorMode = factorMode;
    }

    public AssuranceMethod inactivityPeriod(String inactivityPeriod) {
        this.inactivityPeriod = inactivityPeriod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The inactivity duration after which the user must re-authenticate. Use the ISO 8601 period format (for example, PT2H).")
    @JsonProperty(value="inactivityPeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInactivityPeriod() {
        return this.inactivityPeriod;
    }

    @JsonProperty(value="inactivityPeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInactivityPeriod(String inactivityPeriod) {
        this.inactivityPeriod = inactivityPeriod;
    }

    public AssuranceMethod reauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The duration after which the user must re-authenticate, regardless of user activity. Keep in mind that the re-authentication intervals for constraints take precedent over this value. Use the ISO 8601 period format for recurring time intervals (for example, PT2H, PT0S, PT43800H, and so on).")
    @JsonProperty(value="reauthenticateIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReauthenticateIn() {
        return this.reauthenticateIn;
    }

    @JsonProperty(value="reauthenticateIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssuranceMethod assuranceMethod = (AssuranceMethod)o;
        return Objects.equals(this.constraints, assuranceMethod.constraints) && Objects.equals((Object)this.factorMode, (Object)assuranceMethod.factorMode) && Objects.equals(this.inactivityPeriod, assuranceMethod.inactivityPeriod) && Objects.equals(this.reauthenticateIn, assuranceMethod.reauthenticateIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.constraints, this.factorMode, this.inactivityPeriod, this.reauthenticateIn, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssuranceMethod {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    constraints: ").append(this.toIndentedString(this.constraints)).append("\n");
        sb.append("    factorMode: ").append(this.toIndentedString((Object)this.factorMode)).append("\n");
        sb.append("    inactivityPeriod: ").append(this.toIndentedString(this.inactivityPeriod)).append("\n");
        sb.append("    reauthenticateIn: ").append(this.toIndentedString(this.reauthenticateIn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

